package org.uqbar.arena.xtend;

import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.mockito.internal.configuration.ClassPathLoader;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.invocation.MockHandler;
import org.mockito.plugins.MockMaker;
import org.uqbar.arena.widgets.Control;
import org.uqbar.arena.xtend.ArenaMockHandler;
import org.uqbar.lacar.ui.model.ControlBuilder;
import org.uqbar.lacar.ui.model.bindings.Binding;

/**
 * Arena extensions to provide type-safe bindings.
 * That is without using strings for property names but closures.
 * 
 * @author jfernandes
 */
@SuppressWarnings("all")
public class ArenaTypeSafeBindingExtensions {
  public <M extends Object, R extends Object> Binding<Object, Control, ControlBuilder> bindValue(final Control control, final Function1<M, R> propertyBinder) {
    Binding<Object, Control, ControlBuilder> _xblockexpression = null;
    {
      Object _containerModelObject = control.<Object>getContainerModelObject();
      final String modelObservableAsString = ArenaTypeSafeBindingExtensions.<M, R>calculateObservable(_containerModelObject, propertyBinder);
      _xblockexpression = control.<Object, ControlBuilder>bindValueToProperty(modelObservableAsString);
    }
    return _xblockexpression;
  }
  
  public static <M extends Object, R extends Object> String calculateObservable(final Object model, final Function1<M, R> propertyBinder) {
    String _xblockexpression = null;
    {
      Class<?> _class = model.getClass();
      final Class<M> concreteModelType = ((Class<M>) _class);
      final ArenaMockHandler handler = ArenaTypeSafeBindingExtensions.createInvocationHandler();
      final M mock = ArenaTypeSafeBindingExtensions.<M>createMockFor(concreteModelType, handler);
      propertyBinder.apply(mock);
      _xblockexpression = handler.getPropertyName();
    }
    return _xblockexpression;
  }
  
  public static ArenaMockHandler createInvocationHandler() {
    return new ArenaMockHandler();
  }
  
  public static <T extends Object> T createMockFor(final Class<T> type, final MockHandler handler) {
    MockMaker _mockMaker = ClassPathLoader.getMockMaker();
    CreationSettings<T> _createMockCreationSettings = ArenaTypeSafeBindingExtensions.<T>createMockCreationSettings(type);
    return _mockMaker.<T>createMock(_createMockCreationSettings, handler);
  }
  
  public static <T extends Object> CreationSettings<T> createMockCreationSettings(final Class<T> typeToMock) {
    CreationSettings<T> _creationSettings = new CreationSettings<T>();
    final Procedure1<CreationSettings<T>> _function = new Procedure1<CreationSettings<T>>() {
      public void apply(final CreationSettings<T> it) {
        it.setTypeToMock(typeToMock);
      }
    };
    return ObjectExtensions.<CreationSettings<T>>operator_doubleArrow(_creationSettings, _function);
  }
}
