/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.islands.IslandEvolutionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IslandsView
extends JPanel
implements IslandEvolutionObserver<Object> {
    private static final String FITTEST_INDIVIDUAL_LABEL = "Fittest Individual";
    private static final String MEAN_FITNESS_LABEL = "Mean Fitness/Standard Deviation";
    private final DefaultCategoryDataset bestDataSet = new DefaultCategoryDataset();
    private final DefaultStatisticalCategoryDataset meanDataSet = new DefaultStatisticalCategoryDataset();
    private final JFreeChart chart;
    private final AtomicInteger islandCount = new AtomicInteger(0);
    private double max = 0.0;
    private final StatisticalLineAndShapeRenderer meanRenderer = new StatisticalLineAndShapeRenderer();

    IslandsView() {
        super(new BorderLayout());
        this.chart = ChartFactory.createBarChart((String)"Island Population Fitness", (String)"Island No.", (String)"Candidate Fitness", (CategoryDataset)this.bestDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        plot.getRangeAxis().setAutoRange(false);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.meanRenderer.setBaseLinesVisible(false);
        ChartPanel chartPanel = new ChartPanel(this.chart, 680, 420, 300, 200, 1024, 768, false, false, true, true, false, false);
        this.add((Component)chartPanel, "Center");
        this.add((Component)this.createControls(), "South");
    }

    private JComponent createControls() {
        JPanel controls = new JPanel(new FlowLayout(2));
        JCheckBox meanCheckBox = new JCheckBox("Show Mean and Standard Deviation", false);
        meanCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                IslandsView.this.chart.setNotify(false);
                CategoryPlot plot = (CategoryPlot)IslandsView.this.chart.getPlot();
                if (itemEvent.getStateChange() == 1) {
                    plot.setDataset(1, (CategoryDataset)IslandsView.this.meanDataSet);
                    plot.setRenderer(1, (CategoryItemRenderer)IslandsView.this.meanRenderer);
                } else {
                    plot.setDataset(1, null);
                    plot.setRenderer(1, null);
                }
                IslandsView.this.chart.setNotify(true);
            }
        });
        controls.add(meanCheckBox);
        return controls;
    }

    public void islandPopulationUpdate(final int islandIndex, final PopulationData<? extends Object> populationData) {
        if (islandIndex >= this.islandCount.get()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Integer i = IslandsView.this.islandCount.get();
                        while (i <= islandIndex) {
                            IslandsView.this.bestDataSet.addValue(0.0, (Comparable)((Object)IslandsView.FITTEST_INDIVIDUAL_LABEL), (Comparable)i);
                            IslandsView.this.meanDataSet.add(0.0, 0.0, (Comparable)((Object)IslandsView.MEAN_FITNESS_LABEL), (Comparable)i);
                            IslandsView.this.islandCount.incrementAndGet();
                            Integer n = i;
                            Integer n2 = i = Integer.valueOf(i + 1);
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(ex.getCause());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IslandsView.this.chart.setNotify(false);
                IslandsView.this.bestDataSet.setValue(populationData.getBestCandidateFitness(), (Comparable)((Object)IslandsView.FITTEST_INDIVIDUAL_LABEL), (Comparable)Integer.valueOf(islandIndex));
                IslandsView.this.meanDataSet.remove((Comparable)((Object)IslandsView.MEAN_FITNESS_LABEL), (Comparable)Integer.valueOf(islandIndex));
                IslandsView.this.meanDataSet.add(populationData.getMeanFitness(), populationData.getFitnessStandardDeviation(), (Comparable)((Object)IslandsView.MEAN_FITNESS_LABEL), (Comparable)Integer.valueOf(islandIndex));
                ValueAxis rangeAxis = ((CategoryPlot)IslandsView.this.chart.getPlot()).getRangeAxis();
                IslandsView.this.max = Math.max(IslandsView.this.max, populationData.getBestCandidateFitness());
                IslandsView.this.max = Math.max(IslandsView.this.max, populationData.getMeanFitness() + populationData.getFitnessStandardDeviation());
                while (IslandsView.this.max > rangeAxis.getUpperBound()) {
                    rangeAxis.setUpperBound(rangeAxis.getUpperBound() * 2.0);
                }
                IslandsView.this.chart.setNotify(true);
            }
        });
    }

    public void populationUpdate(PopulationData<? extends Object> populationData) {
    }
}

