/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.interactive.Renderer;
import org.uncommons.watchmaker.framework.islands.IslandEvolutionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FittestCandidateView<T>
extends JPanel
implements IslandEvolutionObserver<T> {
    private static final Font BIG_FONT = new Font("Dialog", 1, 16);
    private final Renderer<? super T, JComponent> renderer;
    private final JLabel fitnessLabel = new JLabel("N/A", 0);
    private final JScrollPane scroller = new JScrollPane();
    private T fittestCandidate = null;
    private JComponent renderedCandidate = null;

    FittestCandidateView(Renderer<? super T, JComponent> renderer) {
        super(new BorderLayout(0, 10));
        this.renderer = renderer;
        JPanel header = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Fitness", 0);
        header.add((Component)label, "North");
        this.fitnessLabel.setFont(BIG_FONT);
        header.add((Component)this.fitnessLabel, "Center");
        this.add((Component)header, "North");
        this.scroller.setBackground(null);
        this.scroller.getViewport().setBackground(null);
        this.scroller.setBorder(null);
        this.add((Component)this.scroller, "Center");
        this.fitnessLabel.setName("FitnessLabel");
    }

    public void populationUpdate(final PopulationData<? extends T> populationData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FittestCandidateView.this.fitnessLabel.setText(String.valueOf(populationData.getBestCandidateFitness()));
                if (populationData.getBestCandidate() != FittestCandidateView.this.fittestCandidate) {
                    FittestCandidateView.this.fittestCandidate = populationData.getBestCandidate();
                    FittestCandidateView.this.renderedCandidate = (JComponent)FittestCandidateView.this.renderer.render(FittestCandidateView.this.fittestCandidate);
                    FittestCandidateView.this.scroller.setViewportView(FittestCandidateView.this.renderedCandidate);
                }
            }
        });
    }

    public void islandPopulationUpdate(int islandIndex, PopulationData<? extends T> populationData) {
    }
}

