/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.StandardChartTheme;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.interactive.Renderer;
import org.uncommons.watchmaker.framework.islands.IslandEvolutionObserver;
import org.uncommons.watchmaker.swing.ObjectSwingRenderer;
import org.uncommons.watchmaker.swing.evolutionmonitor.FittestCandidateView;
import org.uncommons.watchmaker.swing.evolutionmonitor.IslandsView;
import org.uncommons.watchmaker.swing.evolutionmonitor.JVMView;
import org.uncommons.watchmaker.swing.evolutionmonitor.PopulationFitnessView;
import org.uncommons.watchmaker.swing.evolutionmonitor.StatusBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMonitor<T>
implements IslandEvolutionObserver<T> {
    private final List<IslandEvolutionObserver<? super T>> views = new LinkedList<IslandEvolutionObserver<? super T>>();
    private JComponent monitorComponent;
    private Window window = null;
    private final boolean islands;

    public EvolutionMonitor() {
        this(false);
    }

    public EvolutionMonitor(boolean islands) {
        this(new ObjectSwingRenderer(), islands);
    }

    public EvolutionMonitor(final Renderer<? super T, JComponent> renderer, boolean islands) {
        this.islands = islands;
        if (SwingUtilities.isEventDispatchThread()) {
            this.init(renderer);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EvolutionMonitor.this.init(renderer);
                    }
                });
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void init(Renderer<? super T, JComponent> renderer) {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JTabbedPane tabs = new JTabbedPane();
        this.monitorComponent = new JPanel(new BorderLayout());
        this.monitorComponent.add((Component)tabs, "Center");
        FittestCandidateView<? super T> candidateView = new FittestCandidateView<T>(renderer);
        tabs.add("Fittest Individual", candidateView);
        this.views.add(candidateView);
        PopulationFitnessView fitnessView = new PopulationFitnessView(this.islands);
        tabs.add(this.islands ? "Global Population" : "Population Fitness", fitnessView);
        this.views.add(fitnessView);
        if (this.islands) {
            IslandsView islandsView = new IslandsView();
            tabs.add("Island Populations", islandsView);
            this.views.add(islandsView);
        }
        JVMView jvmView = new JVMView();
        tabs.add("JVM Memory", jvmView);
        StatusBar statusBar = new StatusBar(this.islands);
        this.monitorComponent.add((Component)statusBar, "South");
        this.views.add(statusBar);
    }

    public void populationUpdate(PopulationData<? extends T> populationData) {
        for (IslandEvolutionObserver<? super T> islandEvolutionObserver : this.views) {
            islandEvolutionObserver.populationUpdate(populationData);
        }
    }

    public void islandPopulationUpdate(int islandIndex, PopulationData<? extends T> populationData) {
        for (IslandEvolutionObserver<? super T> islandEvolutionObserver : this.views) {
            islandEvolutionObserver.islandPopulationUpdate(islandIndex, populationData);
        }
    }

    public JComponent getGUIComponent() {
        return this.monitorComponent;
    }

    public void showInFrame(final String title, final boolean exitOnClose) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame(title);
                frame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
                EvolutionMonitor.this.showWindow(frame);
            }
        });
    }

    public void showInDialog(final JFrame owner, final String title, final boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = new JDialog(owner, title, modal);
                dialog.setDefaultCloseOperation(2);
                EvolutionMonitor.this.showWindow(dialog);
            }
        });
    }

    private void showWindow(Window newWindow) {
        if (this.window != null) {
            this.window.remove(this.getGUIComponent());
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
        newWindow.add((Component)this.getGUIComponent(), "Center");
        newWindow.pack();
        newWindow.setVisible(true);
        this.window = newWindow;
    }
}

