/*
 * Decompiled with CFR 0.152.
 */
package org.tuxdevelop.spring.batch.lightmin.client.classic.service;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.tuxdevelop.spring.batch.lightmin.client.api.LightminClientApplication;
import org.tuxdevelop.spring.batch.lightmin.client.classic.configuration.LightminClientClassicConfigurationProperties;
import org.tuxdevelop.spring.batch.lightmin.client.configuration.LightminClientProperties;
import org.tuxdevelop.spring.batch.lightmin.client.service.LightminServerLocatorService;
import org.tuxdevelop.spring.batch.lightmin.util.RequestUtil;

public class LightminClientRegistratorService {
    private static final Logger log = LoggerFactory.getLogger(LightminClientRegistratorService.class);
    private static final String SLASH = "/";
    private final AtomicReference<String> registeredId = new AtomicReference();
    private final LightminClientProperties lightminClientProperties;
    private final LightminClientClassicConfigurationProperties lightminClientClassicConfigurationProperties;
    private final RestTemplate restTemplate;
    private final JobRegistry jobRegistry;
    private final LightminServerLocatorService lightminServerLocatorService;

    public LightminClientRegistratorService(LightminClientProperties lightminClientProperties, LightminClientClassicConfigurationProperties lightminClientClassicConfigurationProperties, RestTemplate restTemplate, JobRegistry jobRegistry, LightminServerLocatorService lightminServerLocatorService) {
        this.lightminClientProperties = lightminClientProperties;
        this.lightminClientClassicConfigurationProperties = lightminClientClassicConfigurationProperties;
        this.restTemplate = restTemplate;
        this.jobRegistry = jobRegistry;
        this.lightminServerLocatorService = lightminServerLocatorService;
    }

    public Boolean register() {
        Boolean isRegistrationSuccessful = Boolean.FALSE;
        LightminClientApplication lightminClientApplication = LightminClientApplication.createApplication(new LinkedList(this.jobRegistry.getJobNames()), (LightminClientProperties)this.lightminClientProperties);
        HttpEntity entity = RequestUtil.createApplicationJsonEntity((Object)lightminClientApplication);
        List serverUrls = this.lightminServerLocatorService.getRemoteUrls();
        for (String lightminUrl : serverUrls) {
            try {
                String applicationPath = this.getLightminServerApplicationPath(lightminUrl, this.lightminClientClassicConfigurationProperties.getServer().getApiApplicationsPath());
                String lightminAppplicationsUrl = lightminUrl + applicationPath;
                ResponseEntity response = this.restTemplate.postForEntity(lightminAppplicationsUrl, (Object)entity, LightminClientApplication.class, new Object[0]);
                if (response.getStatusCode().equals((Object)HttpStatus.CREATED)) {
                    if (this.registeredId.compareAndSet(null, ((LightminClientApplication)response.getBody()).getId())) {
                        log.info("Application registered itself as {}", response.getBody());
                    } else {
                        log.debug("Application refreshed itself as {}", response.getBody());
                    }
                    isRegistrationSuccessful = Boolean.TRUE;
                    if (!this.lightminClientClassicConfigurationProperties.isRegisterOnce()) continue;
                    break;
                }
                log.warn("Application failed to registered itself as {}. Response: {}", (Object)lightminClientApplication, (Object)response.toString());
            }
            catch (Exception ex) {
                log.warn("Failed to register application as {} at spring-boot-lightminClientServerProperties ({}): {}", new Object[]{lightminClientApplication, this.lightminClientClassicConfigurationProperties.getServer().getLightminUrl(), ex.getMessage()});
            }
        }
        return isRegistrationSuccessful;
    }

    @EventListener(value={ContextClosedEvent.class})
    public void deregister(ContextClosedEvent event) {
        log.debug("Retrievied ContextClosedEvent for dereigistration: {}", (Object)event);
        if (this.lightminClientClassicConfigurationProperties.isAutoDeregistration()) {
            String id = this.registeredId.get();
            if (id != null) {
                List serverUrls = this.lightminServerLocatorService.getRemoteUrls();
                for (String lightminUrl : serverUrls) {
                    try {
                        String applicationPath = this.getLightminServerApplicationPath(lightminUrl, this.lightminClientClassicConfigurationProperties.getServer().getApiApplicationsPath());
                        this.restTemplate.delete(lightminUrl + applicationPath + SLASH + id, new Object[0]);
                        this.registeredId.compareAndSet(id, null);
                        if (!this.lightminClientClassicConfigurationProperties.isRegisterOnce()) continue;
                        break;
                    }
                    catch (Exception ex) {
                        log.warn("Failed to deregister application (id={}) at spring-batch-lightmin ({}): {}", new Object[]{id, lightminUrl, ex.getMessage()});
                    }
                }
            } else {
                log.debug("Application id is null, deregistration deactivated");
            }
        } else {
            log.debug("No auto deregistration active, nothinhg to do");
        }
    }

    private String getLightminServerApplicationPath(String lightminUrl, String applicationApiPath) {
        String path = StringUtils.hasText((String)applicationApiPath) ? (lightminUrl.endsWith(SLASH) ? (applicationApiPath.startsWith(SLASH) ? applicationApiPath.replaceFirst(SLASH, "") : applicationApiPath) : (applicationApiPath.startsWith(SLASH) ? applicationApiPath : SLASH + applicationApiPath)) : "";
        return path;
    }
}

