/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.abi;

import java.math.BigInteger;
import java.util.List;
import org.tron.tronj.abi.FunctionEncoder;
import org.tron.tronj.abi.TypeEncoder;
import org.tron.tronj.abi.datatypes.Function;
import org.tron.tronj.abi.datatypes.StaticArray;
import org.tron.tronj.abi.datatypes.Type;
import org.tron.tronj.abi.datatypes.Uint;

public class DefaultFunctionEncoder
extends FunctionEncoder {
    @Override
    public String encodeFunction(Function function) {
        List<Type> parameters = function.getInputParameters();
        String methodSignature = DefaultFunctionEncoder.buildMethodSignature(function.getName(), parameters);
        String methodId = DefaultFunctionEncoder.buildMethodId(methodSignature);
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return DefaultFunctionEncoder.encodeParameters(parameters, result);
    }

    @Override
    public String encodeParameters(List<Type> parameters) {
        return DefaultFunctionEncoder.encodeParameters(parameters, new StringBuilder());
    }

    private static String encodeParameters(List<Type> parameters, StringBuilder result) {
        int dynamicDataOffset = DefaultFunctionEncoder.getLength(parameters) * 32;
        StringBuilder dynamicData = new StringBuilder();
        for (Type parameter : parameters) {
            String encodedValue = TypeEncoder.encode(parameter);
            if (TypeEncoder.isDynamic(parameter)) {
                String encodedDataOffset = TypeEncoder.encodeNumeric(new Uint(BigInteger.valueOf(dynamicDataOffset)));
                result.append(encodedDataOffset);
                dynamicData.append(encodedValue);
                dynamicDataOffset += encodedValue.length() >> 1;
                continue;
            }
            result.append(encodedValue);
        }
        result.append((CharSequence)dynamicData);
        return result.toString();
    }

    private static int getLength(List<Type> parameters) {
        int count = 0;
        for (Type type : parameters) {
            if (type instanceof StaticArray) {
                count += ((StaticArray)type).getValue().size();
                continue;
            }
            ++count;
        }
        return count;
    }
}

