/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.abi.datatypes;

import java.math.BigInteger;
import org.tron.tronj.abi.datatypes.NumericType;

public abstract class IntType
extends NumericType {
    private final int bitSize;

    public IntType(String typePrefix, int bitSize, BigInteger value) {
        super(typePrefix + bitSize, value);
        this.bitSize = bitSize;
        if (!this.valid()) {
            throw new UnsupportedOperationException("Bit size must be 8 bit aligned, and in range 0 < bitSize <= 256");
        }
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    protected boolean valid() {
        return IntType.isValidBitSize(this.bitSize) && IntType.isValidBitCount(this.bitSize, this.value);
    }

    private static boolean isValidBitSize(int bitSize) {
        return bitSize % 8 == 0 && bitSize > 0 && bitSize <= 256;
    }

    private static boolean isValidBitCount(int bitSize, BigInteger value) {
        return value.bitLength() <= bitSize;
    }
}

