/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.abi.datatypes;

import java.math.BigInteger;
import java.util.Arrays;
import org.tron.tronj.abi.datatypes.Type;
import org.tron.tronj.abi.datatypes.Uint;
import org.tron.tronj.utils.Base58Check;
import org.tron.tronj.utils.Numeric;

public class Address
implements Type<String> {
    public static final String TYPE_NAME = "address";
    public static final int DEFAULT_LENGTH = 160;
    public static final Address DEFAULT = new Address(BigInteger.ZERO);
    private final Uint value;

    public Address(Uint value) {
        this.value = value;
    }

    public Address(BigInteger value) {
        this(160, value);
    }

    public Address(int bitSize, BigInteger value) {
        this(new Uint(bitSize, value));
    }

    public Address(String value) {
        if (value.startsWith("T")) {
            byte[] rawValue = Base58Check.base58ToBytes((String)value);
            this.value = new Uint(160, Numeric.toBigInt((byte[])Arrays.copyOfRange(rawValue, 1, 21)));
        } else {
            this.value = value.startsWith("41") ? new Uint(160, Numeric.toBigInt((String)value.substring(2))) : new Uint(160, Numeric.toBigInt((String)value));
        }
    }

    public Address(int bitSize, String hexValue) {
        this(bitSize, Numeric.toBigInt((String)hexValue));
    }

    public Uint toUint() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }

    public String toString() {
        byte[] rawAddr = Numeric.toBytesPadded((BigInteger)this.value.getValue(), (int)21);
        rawAddr[0] = 65;
        return Base58Check.bytesToBase58((byte[])rawAddr);
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.value != null ? this.value.value.equals(address.value.value) : address.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

