/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.notify.sender.couch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tiogasolutions.notify.notifier.LqException;
import org.tiogasolutions.notify.notifier.json.LqRequestJsonBuilder;
import org.tiogasolutions.notify.notifier.request.LqAttachment;
import org.tiogasolutions.notify.notifier.request.LqRequest;
import org.tiogasolutions.notify.notifier.request.LqRequestStatus;
import org.tiogasolutions.notify.notifier.request.LqResponse;
import org.tiogasolutions.notify.notifier.sender.LqAbstractSender;
import org.tiogasolutions.notify.notifier.uuid.TimeUuid;
import org.tiogasolutions.notify.sender.couch.JsonParser;
import org.tiogasolutions.notify.sender.couch.LqCouchSenderSetup;

public class LqCouchSender
extends LqAbstractSender {
    private static final Logger log = LoggerFactory.getLogger(LqCouchSender.class);
    private final ExecutorService executorService;
    private final String couchUrl;
    private final String databaseName;
    private final String username;
    private final String password;

    public LqCouchSender(String couchUrl, String databaseName, String username, String password) {
        this.couchUrl = couchUrl;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.executorService = Executors.newSingleThreadExecutor();
        log.debug("Configured for couch database {} at {}", (Object)databaseName, (Object)couchUrl);
    }

    public LqCouchSender(LqCouchSenderSetup setup) {
        this(setup.getCouchUrl(), setup.getDatabaseName(), setup.getUsername(), setup.getPassword());
    }

    public Future<LqResponse> send(LqRequest request) {
        return this.sendJaxRs(request);
    }

    private Future<LqResponse> sendJaxRs(LqRequest request) {
        Callable<LqResponse> callable = () -> {
            try {
                String requestId = TimeUuid.randomUUID().toString();
                Client client = ClientBuilder.newBuilder().build();
                if (request.getAttachments().isEmpty()) {
                    LqRequestStatus status = LqRequestStatus.READY;
                    InputStream is = this.toInputStream(request, requestId, null, status, "}");
                    this.putDocument(request, client, requestId, null, is, "application/json", new String[0]);
                } else {
                    LqRequestStatus status = LqRequestStatus.SENDING;
                    InputStream is = this.toInputStream(request, requestId, null, status, "}");
                    String revision = this.putDocument(request, client, requestId, null, is, "application/json", new String[0]);
                    for (LqAttachment attachment : request.getAttachments()) {
                        is = attachment.getInputStream();
                        revision = this.putDocument(request, client, requestId, revision, is, attachment.getContentType(), attachment.getName());
                    }
                    status = LqRequestStatus.READY;
                    String suffix = this.parseSuffix(request, client, requestId);
                    is = this.toInputStream(request, requestId, revision, status, suffix);
                    this.putDocument(request, client, requestId, revision, is, "application/json", new String[0]);
                }
                return LqResponse.newSuccess((LqRequest)request);
            }
            catch (ProcessingException e) {
                this.callbacks.callFailure(e.getLqResponse());
                return e.getLqResponse();
            }
        };
        return this.executorService.submit(callable);
    }

    protected String parseSuffix(LqRequest request, Client client, String requestId) throws ProcessingException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.couchUrl).path(this.databaseName).path(requestId);
        Invocation.Builder builder = client.target(uriBuilder).request(new String[]{"application/json"});
        builder.header("Authorization", (Object)LqCouchSender.getBasicAuthentication(this.username, this.password));
        builder.header("Content-Type", (Object)"application/json");
        Response response = builder.get();
        if (response.getStatus() != 200) {
            String msg = String.format("%s: Unable to put request", response.getStatus());
            LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)new LqException(msg));
            throw new ProcessingException(lqResponse);
        }
        String couchResponse = (String)response.readEntity(String.class);
        Map<String, String> map = new JsonParser().parse(couchResponse);
        String attachments = map.get("_attachments");
        return ", \"_attachments\" : " + attachments + "}";
    }

    private String putDocument(LqRequest request, Client client, String requestId, String revision, InputStream content, String contentType, String ... paths) throws ProcessingException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.couchUrl).path(this.databaseName).path(requestId);
        for (String path : paths) {
            uriBuilder.path(path);
        }
        if (revision != null) {
            uriBuilder.queryParam("rev", new Object[]{revision});
        }
        Invocation.Builder builder = client.target(uriBuilder).request(new String[]{"application/json"});
        builder.header("Authorization", (Object)LqCouchSender.getBasicAuthentication(this.username, this.password));
        builder.header("Content-Type", (Object)contentType);
        Entity entity = Entity.entity((Object)content, (String)contentType);
        Response response = builder.put(entity);
        String couchResponse = (String)response.readEntity(String.class);
        if (response.getStatus() != 201) {
            String msg = String.format("%s: Unable to put request%n%s", response.getStatus(), couchResponse);
            LqResponse lqResponse = LqResponse.newFailure((LqRequest)request, (Throwable)new LqException(msg));
            throw new ProcessingException(lqResponse);
        }
        return this.parseRevision(couchResponse);
    }

    private InputStream toInputStream(LqRequest request, String requestId, String revision, LqRequestStatus status, String suffix) {
        String json = new LqRequestJsonBuilder().toJson(request, status);
        String prefix = revision == null ? "{\n   \"_id\": \"" + requestId + "\",\n" + "   \"entityType\": \"LqRequest\",\n" + "   \"entity\": " : "{\n   \"_id\": \"" + requestId + "\",\n" + "   \"_rev\": \"" + revision + "\",\n" + "   \"entityType\": \"LqRequest\",\n" + "   \"entity\": ";
        String content = prefix + json + suffix;
        return new ByteArrayInputStream(content.getBytes());
    }

    private String parseRevision(String response) {
        String REV = "\"rev\"";
        int posA = response.indexOf(REV);
        if (posA < 0) {
            throw new LqException("Cannot parse revision from couch response: " + response);
        }
        if ((posA = response.indexOf(":", posA + REV.length())) < 0) {
            throw new LqException("Cannot parse revision from couch response: " + response);
        }
        if ((posA = response.indexOf("\"", posA + 1)) < 0) {
            throw new LqException("Cannot parse revision from couch response: " + response);
        }
        int posB = response.indexOf("\"", posA + 1);
        if (posA < 0) {
            throw new LqException("Cannot parse revision from couch response: " + response);
        }
        return response.substring(posA + 1, posB);
    }

    private static String getBasicAuthentication(String username, String password) {
        try {
            String token = username + ":" + password;
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }

    public void dispose() {
        this.executorService.shutdown();
    }

    public static class ProcessingException
    extends Exception {
        private final LqResponse lqResponse;

        public ProcessingException(LqResponse lqResponse) {
            this.lqResponse = lqResponse;
        }

        public LqResponse getLqResponse() {
            return this.lqResponse;
        }
    }
}

