/*
 * Decompiled with CFR 0.152.
 */
package examples.resource;

import examples.resource.model.GreetingModel;
import examples.resource.repository.GreetingRepository;
import examples.resource.repository.entity.GreetingEntity;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UpdateGreetingResource {
    private final GreetingRepository greetingRepository;
    private final ModelMapper modelMapper;

    @Autowired
    UpdateGreetingResource(GreetingRepository greetingRepository, ModelMapper modelMapper) {
        this.greetingRepository = greetingRepository;
        this.modelMapper = modelMapper;
    }

    @RequestMapping(path={"/greetings/{id}"}, method={RequestMethod.PUT}, consumes={"application/json", "application/x-www-form-urlencoded"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity updateGreeting(@NotNull @PathVariable(value="id") UUID id, @Valid @RequestBody GreetingModel model) {
        GreetingEntity existingEntity = (GreetingEntity)this.greetingRepository.findOne(id);
        if (existingEntity == null) {
            return ResponseEntity.notFound().build();
        }
        this.modelMapper.map((Object)model, (Object)existingEntity);
        this.greetingRepository.save(existingEntity);
        return ResponseEntity.accepted().build();
    }
}

