/*
 * Decompiled with CFR 0.152.
 */
package examples.resource;

import examples.resource.model.GreetingModel;
import examples.resource.repository.GreetingRepository;
import examples.resource.repository.entity.GreetingEntity;
import java.net.URI;
import javax.validation.Valid;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CreateGreetingResource {
    private final GreetingRepository greetingRepository;
    private final ModelMapper modelMapper;

    @Autowired
    CreateGreetingResource(GreetingRepository greetingRepository, ModelMapper modelMapper) {
        this.greetingRepository = greetingRepository;
        this.modelMapper = modelMapper;
    }

    @RequestMapping(path={"/greetings"}, method={RequestMethod.POST}, consumes={"application/json", "application/x-www-form-urlencoded"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity create(@Valid @RequestBody GreetingModel model) {
        GreetingEntity entity = (GreetingEntity)this.modelMapper.map((Object)model, GreetingEntity.class);
        entity = (GreetingEntity)this.greetingRepository.save(entity);
        ControllerLinkBuilder link = (ControllerLinkBuilder)ControllerLinkBuilder.linkTo(CreateGreetingResource.class).slash((Object)entity.getId().toString());
        return ResponseEntity.created((URI)link.toUri()).build();
    }
}

