/*
 * Decompiled with CFR 0.152.
 */
package examples.requiredresource;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCDataSource;
import org.testifyproject.LocalResourceInstance;
import org.testifyproject.LocalResourceProvider;
import org.testifyproject.TestContext;
import org.testifyproject.annotation.LocalResource;
import org.testifyproject.core.LocalResourceInstanceBuilder;
import org.testifyproject.trait.PropertiesReader;

public class InMemoryHSQLResource
implements LocalResourceProvider<JDBCDataSource, DataSource, Connection> {
    private JDBCDataSource server;
    private Connection client;

    public JDBCDataSource configure(TestContext testContext, LocalResource localResource, PropertiesReader configReader) {
        JDBCDataSource dataSource = new JDBCDataSource();
        String url = String.format("jdbc:hsqldb:mem:%s?default_schema=public", testContext.getName());
        dataSource.setUrl(url);
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    public LocalResourceInstance start(TestContext testContext, LocalResource localResource, JDBCDataSource dataSource) throws Exception {
        this.server = dataSource;
        this.client = dataSource.getConnection();
        return LocalResourceInstanceBuilder.builder().resource((Object)this.server, DataSource.class).client((Object)this.client, Connection.class).build("hsql");
    }

    public void stop(TestContext testContext, LocalResource localResource) throws Exception {
        this.server.getConnection().createStatement().executeQuery("SHUTDOWN");
        this.client.close();
    }
}

