/*
 * Decompiled with CFR 0.152.
 */
package examples.requiredresource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCDataSource;
import org.testifyproject.ResourceInstance;
import org.testifyproject.ResourceProvider;
import org.testifyproject.TestContext;
import org.testifyproject.core.ResourceInstanceBuilder;

public class InMemoryHSQLResource
implements ResourceProvider<JDBCDataSource, DataSource, Connection> {
    private JDBCDataSource server;
    private Connection client;

    public JDBCDataSource configure(TestContext testContext) {
        JDBCDataSource dataSource = new JDBCDataSource();
        String url = String.format("jdbc:hsqldb:mem:%s?default_schema=public", testContext.getName());
        dataSource.setUrl(url);
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    public ResourceInstance start(TestContext testContext, JDBCDataSource dataSource) {
        try {
            this.server = dataSource;
            this.client = dataSource.getConnection();
            return new ResourceInstanceBuilder().server((Object)this.server, "inmemoryHSQLDataSource", DataSource.class).client((Object)this.client, "inmemoryHSQLConnection", Connection.class).build();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() {
        try {
            this.server.getConnection().createStatement().executeQuery("SHUTDOWN");
            this.client.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

