/*
 * Decompiled with CFR 0.152.
 */
package examples.database;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.glassfish.hk2.api.Factory;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class EntityManagerFactoryProvider
implements Factory<EntityManagerFactory> {
    private final DataSource dataSource;

    @Inject
    EntityManagerFactoryProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Singleton
    public EntityManagerFactory provide() {
        HashMap<String, DataSource> properties = new HashMap<String, DataSource>();
        properties.put("hibernate.connection.datasource", this.dataSource);
        properties.put("hibernate.physical_naming_strategy", (DataSource)new PhysicalNamingStrategyStandardImpl());
        properties.put("hibernate.implicit_naming_strategy", (DataSource)new ImplicitNamingStrategyComponentPathImpl());
        return Persistence.createEntityManagerFactory((String)"example.greeter", properties);
    }

    public void dispose(EntityManagerFactory instance) {
        instance.close();
    }
}

