/*
 * Decompiled with CFR 0.152.
 */
package examples.resource;

import examples.resource.entity.GreetingEntity;
import examples.resource.model.GreetingModel;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="greetings")
@Transactional
public class UpdateGreetingResource {
    private final EntityManager entityManager;

    @Inject
    UpdateGreetingResource(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response updateGreeting(@NotNull @PathParam(value="id") UUID id, @Valid GreetingModel model) {
        GreetingEntity entity = (GreetingEntity)this.entityManager.find(GreetingEntity.class, (Object)id);
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        entity.setPhrase(model.getPhrase());
        this.entityManager.persist((Object)entity);
        return Response.accepted().build();
    }
}

