/*
 * Decompiled with CFR 0.152.
 */
package examples.resource;

import examples.resource.entity.GreetingEntity;
import examples.resource.model.GreetingModel;
import java.net.URI;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.modelmapper.ModelMapper;

@Path(value="greetings")
@Transactional
public class CreateGreetingResource {
    private final EntityManager entityManager;
    private final UriInfo uriInfo;
    private final ModelMapper modelMapper;

    @Inject
    CreateGreetingResource(EntityManager entityManager, UriInfo uriInfo, ModelMapper modelMapper) {
        this.entityManager = entityManager;
        this.uriInfo = uriInfo;
        this.modelMapper = modelMapper;
    }

    @POST
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response create(@Valid GreetingModel model) {
        GreetingEntity entity = (GreetingEntity)this.modelMapper.map((Object)model, GreetingEntity.class);
        this.entityManager.persist((Object)entity);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(entity.getId().toString()).build(new Object[0]);
        return Response.created((URI)location).build();
    }
}

