/*
 * Copyright 2016-2017 Testify Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package examples.resource.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.SafeHtml;

/**
 * A greeting entity.
 *
 * @author saden
 */
@Entity
@Table(name = "Greetings")
@EqualsAndHashCode
@ToString
public class GreetingEntity implements Serializable {

    private UUID id;
    private String phrase;

    public GreetingEntity() {
        this(null);
    }

    public GreetingEntity(String phrase) {
        this.phrase = phrase;
    }

    @Id
    @GeneratedValue(generator = "greetingIdGenerator")
    @GenericGenerator(name = "greetingIdGenerator", strategy = "uuid2")
    @Column(name = "greeting_id", updatable = false, insertable = false)
    public UUID getId() {
        return id;
    }

    @JsonProperty
    public void setId(UUID id) {
        this.id = id;
    }

    @SafeHtml
    @NotNull
    @Column
    public String getPhrase() {
        return phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

}
