/*
 * Decompiled with CFR 0.152.
 */
package examples.resource.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="Greetings")
public class GreetingEntity
implements Serializable {
    private UUID id;
    private String phrase;

    public GreetingEntity() {
    }

    public GreetingEntity(String phrase) {
        this.phrase = phrase;
    }

    @Id
    @GeneratedValue(generator="greetingIdGenerator")
    @GenericGenerator(name="greetingIdGenerator", strategy="uuid2")
    @Column(name="greeting_id", updatable=false, insertable=false)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty
    public void setId(UUID id) {
        this.id = id;
    }

    @SafeHtml
    @NotNull
    @Column
    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.id);
        hash = 59 * hash + Objects.hashCode(this.phrase);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GreetingEntity other = (GreetingEntity)obj;
        if (!Objects.equals(this.phrase, other.phrase)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "GreetingEntity{id=" + this.id + ", phrase=" + this.phrase + '}';
    }
}

