/*
 * Decompiled with CFR 0.152.
 */
package examples.database.transaction;

import examples.database.transaction.PerTransaction;
import examples.database.transaction.PerTransactionImpl;
import examples.database.transaction.TransactionalImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.Transactional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class PerTransactionMethodInterceptor
implements MethodInterceptor {
    private final OperationManager operationManager;
    private final EntityManager entityManager;

    @Inject
    PerTransactionMethodInterceptor(OperationManager operationManager, EntityManager entityManager) {
        this.operationManager = operationManager;
        this.entityManager = entityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        OperationHandle<PerTransaction> handler = this.getOperationHandle();
        EntityTransaction tx = this.entityManager.getTransaction();
        if (tx == null || tx.isActive()) {
            return methodInvocation.proceed();
        }
        try {
            tx.begin();
            result = methodInvocation.proceed();
        }
        catch (Exception e) {
            this.doRollbackOrCommit(methodInvocation, e, tx);
            handler.closeOperation();
            throw e;
        }
        try {
            if (tx.isActive()) {
                tx.commit();
            }
        }
        finally {
            handler.closeOperation();
        }
        return result;
    }

    private synchronized OperationHandle<PerTransaction> getOperationHandle() {
        OperationHandle handler = this.operationManager.getCurrentOperation((Annotation)PerTransactionImpl.INSTANCE);
        if (handler == null) {
            handler = this.operationManager.createAndStartOperation((Annotation)PerTransactionImpl.INSTANCE);
        }
        return handler;
    }

    private void doRollbackOrCommit(MethodInvocation methodInvocation, Exception e, EntityTransaction tx) {
        if (tx.getRollbackOnly()) {
            tx.rollback();
            return;
        }
        Transactional transactional = this.getTransactional(methodInvocation);
        boolean commit = true;
        for (Class rollbackOn : transactional.rollbackOn()) {
            if (!rollbackOn.isInstance(e)) continue;
            commit = false;
            for (Class exceptOn : transactional.dontRollbackOn()) {
                if (!exceptOn.isInstance(e)) continue;
                commit = true;
                break;
            }
            if (commit) break;
            tx.rollback();
            break;
        }
        if (commit && tx.isActive()) {
            tx.commit();
        }
    }

    private Transactional getTransactional(MethodInvocation methodInvocation) {
        Class<?> targetClass;
        Method method = methodInvocation.getMethod();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null && (transactional = (targetClass = methodInvocation.getThis().getClass()).getAnnotation(Transactional.class)) == null) {
            transactional = TransactionalImpl.INSTANCE;
        }
        return transactional;
    }
}

