/*
 * Decompiled with CFR 0.152.
 */
package examples.database.transaction;

import examples.database.transaction.PerTransactionMethodInterceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.aopalliance.intercept.ConstructorInterceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InterceptionService;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public class PerTransactionInterceptionService
implements InterceptionService {
    private final MethodInterceptor interceptor;

    @Inject
    PerTransactionInterceptionService(PerTransactionMethodInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Filter getDescriptorFilter() {
        return BuilderHelper.allFilter();
    }

    public List<MethodInterceptor> getMethodInterceptors(Method method) {
        return this.getTransactional(method).map(p -> Arrays.asList(this.interceptor)).orElse(null);
    }

    public List<ConstructorInterceptor> getConstructorInterceptors(Constructor<?> constructor) {
        return null;
    }

    private Optional<Transactional> getTransactional(Method method) {
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (transactional == null) {
            transactional = method.getDeclaringClass().getAnnotation(Transactional.class);
        }
        return Optional.ofNullable(transactional);
    }
}

