/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jooq.codegen.migration.runner;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.testcontainers.jooq.codegen.migration.runner.MigrationRunner;
import org.testcontainers.jooq.codegen.migration.runner.RunnerProperties;

public class FlywayRunner
extends HashMap<String, String>
implements MigrationRunner {
    @Override
    public String put(String key, String value) {
        String prefixKey = this.addFlywayPrefix(key);
        return super.put(prefixKey, value);
    }

    @Override
    public void run(RunnerProperties runnerProperties) {
        this.put("flyway.url", runnerProperties.jdbcUrl());
        this.put("flyway.user", runnerProperties.username());
        this.put("flyway.password", runnerProperties.password());
        FluentConfiguration configuration = new FluentConfiguration();
        configuration.configuration((Map)this);
        Flyway flyway = configuration.load();
        flyway.migrate();
    }

    private String addFlywayPrefix(String key) {
        return key.startsWith("flyway.") ? key : "flyway." + key;
    }
}

