/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.commons.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.commons.json.JsonException;
import org.technologybrewery.commons.json.ValidatedElement;

public abstract class AbstractValidatedElement
implements ValidatedElement {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValidatedElement.class);

    public static <T extends AbstractValidatedElement> T readAndValidateJson(File jsonFile, ObjectMapper objectMapper) {
        TypeReference typeReference = new TypeReference<T>(){};
        return AbstractValidatedElement.readAndValidateJson(jsonFile, objectMapper, typeReference);
    }

    public static <T extends AbstractValidatedElement> T readAndValidateJson(File jsonFile, ObjectMapper objectMapper, TypeReference<T> typeReference) {
        String fileIdentifier = jsonFile.getName();
        try {
            AbstractValidatedElement instance = (AbstractValidatedElement)objectMapper.readValue(jsonFile, typeReference);
            JsonNode jsonNode = objectMapper.readTree(jsonFile);
            boolean valid = AbstractValidatedElement.isValid(objectMapper, jsonNode, instance, fileIdentifier);
            if (!valid) {
                if (logger.isDebugEnabled()) {
                    logger.debug(objectMapper.writeValueAsString((Object)instance));
                }
                throw new JsonException(fileIdentifier + " contained validation errors!");
            }
            return (T)instance;
        }
        catch (Exception e) {
            throw new JsonException("Problem reading json file: " + fileIdentifier, e);
        }
    }

    static JavaType listOf(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructCollectionType(List.class, clazz);
    }

    public static <T extends AbstractValidatedElement> List<T> readAndValidateJsonList(File jsonFile, ObjectMapper objectMapper, Class<T> type) {
        String fileIdentifier = jsonFile.getName();
        try {
            List instance = (List)objectMapper.readValue(jsonFile, AbstractValidatedElement.listOf(type));
            JsonNode jsonNode = objectMapper.readTree(jsonFile);
            boolean valid = AbstractValidatedElement.isValid(objectMapper, jsonNode, instance, fileIdentifier);
            if (!valid) {
                if (logger.isDebugEnabled()) {
                    logger.debug(objectMapper.writeValueAsString((Object)instance));
                }
                throw new JsonException(fileIdentifier + " contained validation errors!");
            }
            return instance;
        }
        catch (Exception e) {
            throw new JsonException("Problem reading json file: " + fileIdentifier, e);
        }
    }

    private static <T extends AbstractValidatedElement> boolean isValid(ObjectMapper objectMapper, JsonNode jsonInstance, List<T> instance, String fileIdentifier) throws JsonException {
        boolean isValid = false;
        if (instance != null && !instance.isEmpty()) {
            AbstractValidatedElement firstInstance = (AbstractValidatedElement)instance.get(0);
            isValid = AbstractValidatedElement.checkIsValid(objectMapper, jsonInstance, firstInstance.getJsonSchemaUrl(), fileIdentifier);
        }
        return isValid;
    }

    private static <T extends AbstractValidatedElement> boolean isValid(ObjectMapper objectMapper, JsonNode jsonInstance, T instance, String fileIdentifier) throws JsonException {
        return AbstractValidatedElement.checkIsValid(objectMapper, jsonInstance, instance.getJsonSchemaUrl(), fileIdentifier);
    }

    private static boolean checkIsValid(ObjectMapper objectMapper, JsonNode jsonInstance, URL targetSchemaUrl, String fileIdentifier) throws JsonException {
        ProcessingReport report = null;
        try {
            ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV4).freeze();
            JsonValidator validator = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze().getValidator();
            JsonNode targetSchemaAsJsonNode = objectMapper.readTree(targetSchemaUrl);
            report = validator.validate(targetSchemaAsJsonNode, jsonInstance);
            if (!report.isSuccess()) {
                for (ProcessingMessage processingMessage : report) {
                    logger.error("{} contains the following error:\n\t{}", (Object)fileIdentifier, (Object)processingMessage);
                }
            }
        }
        catch (Exception e) {
            throw new JsonException("Problem determining if json was schema-valid!", e);
        }
        return report.isSuccess();
    }
}

