/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.xml2yaml.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tbee.xml2yaml.XML2YAML;

@Mojo(name="convert", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class XML2YAMLMojo
extends AbstractMojo {
    @Parameter(property="input", required=true)
    private File inputFile;
    @Parameter(property="output", required=false)
    private File outputFile;

    public void execute() throws MojoExecutionException {
        if (!this.inputFile.exists()) {
            throw new MojoExecutionException("Input file does not exist: " + this.inputFile.getAbsolutePath());
        }
        if (this.outputFile == null) {
            String inputFileAbsolutePath = this.inputFile.getAbsolutePath();
            if (this.inputFile.getName().endsWith(".xml")) {
                inputFileAbsolutePath = inputFileAbsolutePath.substring(0, inputFileAbsolutePath.length() - 4);
            }
            this.outputFile = new File(inputFileAbsolutePath + ".yaml");
        }
        try (FileInputStream fileInputStream = new FileInputStream(this.inputFile);
             FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);){
            new XML2YAML().convert((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

