/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;

public class PatchingApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final List<String> defaultDependencies = new ArrayList<String>();

    public void process(Archive<?> appArchive, TestClass testClass) {
        String value;
        if (!(appArchive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected " + appArchive);
        }
        final Manifest manifest = this.getOrCreateManifest(appArchive);
        if (!BundleInfo.isValidBundleManifest((Manifest)manifest)) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        StringBuffer moduleDeps = new StringBuffer((value = attributes.getValue("Dependencies")) != null && value.trim().length() > 0 ? value : "org.jboss.modules");
        for (String dep : defaultDependencies) {
            if (moduleDeps.indexOf(dep) >= 0) continue;
            moduleDeps.append("," + dep);
        }
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        appArchive.delete(manifestPath);
        appArchive.add(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, manifestPath);
    }

    private Manifest getOrCreateManifest(Archive<?> archive) {
        try {
            Manifest manifest;
            Node node = archive.get("META-INF/MANIFEST.MF");
            if (node == null) {
                manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            } else {
                manifest = new Manifest(node.getAsset().openStream());
            }
            return manifest;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot obtain manifest", ex);
        }
    }

    static {
        defaultDependencies.add("deployment.arquillian-service");
        defaultDependencies.add("org.jboss.modules");
        defaultDependencies.add("org.jboss.msc");
    }
}

