/*
 * Decompiled with CFR 0.152.
 */
package demo.monitoring;

import java.util.LinkedList;
import java.util.List;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;

public class StateMachineLogListener
extends StateMachineListenerAdapter<String, String> {
    private final LinkedList<String> messages = new LinkedList();

    public List<String> getMessages() {
        return this.messages;
    }

    public void resetMessages() {
        this.messages.clear();
    }

    public void stateContext(StateContext<String, String> stateContext) {
        if (stateContext.getStage() == StateContext.Stage.STATE_ENTRY) {
            this.messages.addFirst("Enter " + (String)stateContext.getTarget().getId());
        } else if (stateContext.getStage() == StateContext.Stage.STATE_EXIT) {
            this.messages.addFirst("Exit " + (String)stateContext.getSource().getId());
        } else if (stateContext.getStage() == StateContext.Stage.STATEMACHINE_START) {
            this.messages.addLast("Machine started");
        } else if (stateContext.getStage() == StateContext.Stage.STATEMACHINE_STOP) {
            this.messages.addFirst("Machine stopped");
        }
    }
}

