/*
 * Decompiled with CFR 0.152.
 */
package demo.monitoring;

import demo.monitoring.StateMachineLogListener;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

@Controller
public class StateMachineController {
    @Autowired
    private StateMachine<String, String> stateMachine;

    @RequestMapping(value={"/"})
    public String home() {
        return "redirect:/state";
    }

    @RequestMapping(value={"/state"})
    public String feedAndGetStates(@RequestParam(value="events", required=false) List<String> events, Model model) throws Exception {
        StateMachineLogListener listener = new StateMachineLogListener();
        this.stateMachine.addStateListener((StateMachineListener)listener);
        this.stateMachine.startReactively().block();
        if (events != null) {
            for (String event : events) {
                this.stateMachine.sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)event).build())).blockLast();
            }
        }
        this.stateMachine.stopReactively().block();
        model.addAttribute("allEvents", (Object)new String[]{"E1", "E2"});
        model.addAttribute("messages", (Object)this.createMessages(listener.getMessages()));
        return "states";
    }

    private String createMessages(List<String> messages) {
        StringBuilder buf = new StringBuilder();
        for (String message : messages) {
            buf.append(message);
            buf.append("\n");
        }
        return buf.toString();
    }
}

