/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import sample.contact.Contact;
import sample.contact.ContactManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ContextConfiguration(locations={"/applicationContext-common-authorization.xml", "/applicationContext-common-business.xml", "/applicationContext-contacts-test.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class ContactManagerTests {
    @Autowired
    protected ContactManager contactManager;

    void assertContainsContact(long id, List<Contact> contacts) {
        for (Contact contact : contacts) {
            if (!contact.getId().equals(id)) continue;
            return;
        }
        Assert.fail((String)("List of contacts should have contained: " + id));
    }

    void assertDoestNotContainContact(long id, List<Contact> contacts) {
        for (Contact contact : contacts) {
            if (!contact.getId().equals(id)) continue;
            Assert.fail((String)("List of contact should NOT (but did) contain: " + id));
        }
    }

    Contact getContact(String id) {
        for (Contact contact : this.contactManager.getAll()) {
            if (!contact.getId().equals(id)) continue;
            return contact;
        }
        return null;
    }

    private void makeActiveUser(String username) {
        String password = "";
        if ("rod".equals(username)) {
            password = "koala";
        } else if ("dianne".equals(username)) {
            password = "emu";
        } else if ("scott".equals(username)) {
            password = "wombat";
        } else if ("peter".equals(username)) {
            password = "opal";
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
    }

    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testDianne() {
        this.makeActiveUser("dianne");
        List contacts = this.contactManager.getAll();
        Assert.assertEquals((long)4L, (long)contacts.size());
        this.assertContainsContact(4L, contacts);
        this.assertContainsContact(5L, contacts);
        this.assertContainsContact(6L, contacts);
        this.assertContainsContact(8L, contacts);
        this.assertDoestNotContainContact(1L, contacts);
        this.assertDoestNotContainContact(2L, contacts);
        this.assertDoestNotContainContact(3L, contacts);
    }

    @Test
    public void testrod() {
        this.makeActiveUser("rod");
        List contacts = this.contactManager.getAll();
        Assert.assertEquals((long)4L, (long)contacts.size());
        this.assertContainsContact(1L, contacts);
        this.assertContainsContact(2L, contacts);
        this.assertContainsContact(3L, contacts);
        this.assertContainsContact(4L, contacts);
        this.assertDoestNotContainContact(5L, contacts);
        Contact c1 = this.contactManager.getById(new Long(4L));
        this.contactManager.deletePermission(c1, (Sid)new PrincipalSid("bob"), BasePermission.ADMINISTRATION);
        this.contactManager.addPermission(c1, (Sid)new PrincipalSid("bob"), BasePermission.ADMINISTRATION);
    }

    @Test
    public void testScott() {
        this.makeActiveUser("scott");
        List contacts = this.contactManager.getAll();
        Assert.assertEquals((long)5L, (long)contacts.size());
        this.assertContainsContact(4L, contacts);
        this.assertContainsContact(6L, contacts);
        this.assertContainsContact(7L, contacts);
        this.assertContainsContact(8L, contacts);
        this.assertContainsContact(9L, contacts);
        this.assertDoestNotContainContact(1L, contacts);
    }
}

