/*
 * Decompiled with CFR 0.152.
 */
package sample.contact;

import java.util.Iterator;
import java.util.List;
import org.springframework.security.Authentication;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.sid.PrincipalSid;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.test.AbstractTransactionalSpringContextTests;
import sample.contact.Contact;
import sample.contact.ContactManager;

public class GetAllContactsTests
extends AbstractTransactionalSpringContextTests {
    protected ContactManager contactManager;

    protected void assertContainsContact(String id, List contacts) {
        Iterator iter = contacts.iterator();
        System.out.println(contacts);
        while (iter.hasNext()) {
            Contact contact = (Contact)iter.next();
            if (!contact.getId().toString().equals(id)) continue;
            return;
        }
        GetAllContactsTests.fail((String)("List of contacts should have contained: " + id));
    }

    protected void assertNotContainsContact(String id, List contacts) {
        for (Contact domain : contacts) {
            if (!domain.getId().toString().equals(id)) continue;
            GetAllContactsTests.fail((String)("List of contact should NOT (but did) contain: " + id));
        }
    }

    protected String[] getConfigLocations() {
        this.setAutowireMode(1);
        return new String[]{"applicationContext-common-authorization.xml", "applicationContext-common-business.xml", "applicationContext-contacts-test.xml"};
    }

    protected Contact getContact(String id) {
        List contacts = this.contactManager.getAll();
        for (Contact contact : contacts) {
            if (!contact.getId().equals(id)) continue;
            return contact;
        }
        return null;
    }

    protected void makeActiveUser(String username) {
        String password = "";
        if ("rod".equals(username)) {
            password = "koala";
        } else if ("dianne".equals(username)) {
            password = "emu";
        } else if ("scott".equals(username)) {
            password = "wombat";
        } else if ("peter".equals(username)) {
            password = "opal";
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
    }

    protected void onTearDownInTransaction() {
        SecurityContextHolder.clearContext();
    }

    public void setContactManager(ContactManager contactManager) {
        this.contactManager = contactManager;
    }

    public void testDianne() {
        this.makeActiveUser("dianne");
        List contacts = this.contactManager.getAll();
        GetAllContactsTests.assertEquals((int)4, (int)contacts.size());
        this.assertContainsContact(Long.toString(4L), contacts);
        this.assertContainsContact(Long.toString(5L), contacts);
        this.assertContainsContact(Long.toString(6L), contacts);
        this.assertContainsContact(Long.toString(8L), contacts);
        this.assertNotContainsContact(Long.toString(1L), contacts);
        this.assertNotContainsContact(Long.toString(2L), contacts);
        this.assertNotContainsContact(Long.toString(3L), contacts);
    }

    public void testrod() {
        this.makeActiveUser("rod");
        List contacts = this.contactManager.getAll();
        GetAllContactsTests.assertEquals((int)4, (int)contacts.size());
        this.assertContainsContact(Long.toString(1L), contacts);
        this.assertContainsContact(Long.toString(2L), contacts);
        this.assertContainsContact(Long.toString(3L), contacts);
        this.assertContainsContact(Long.toString(4L), contacts);
        this.assertNotContainsContact(Long.toString(5L), contacts);
        Contact c1 = this.contactManager.getById(new Long(4L));
        this.contactManager.deletePermission(c1, (Sid)new PrincipalSid("bob"), BasePermission.ADMINISTRATION);
    }

    public void testScott() {
        this.makeActiveUser("scott");
        List contacts = this.contactManager.getAll();
        GetAllContactsTests.assertEquals((int)5, (int)contacts.size());
        this.assertContainsContact(Long.toString(4L), contacts);
        this.assertContainsContact(Long.toString(6L), contacts);
        this.assertContainsContact(Long.toString(7L), contacts);
        this.assertContainsContact(Long.toString(8L), contacts);
        this.assertContainsContact(Long.toString(9L), contacts);
        this.assertNotContainsContact(Long.toString(1L), contacts);
    }
}

