/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.X509CertificateThumbprintValidator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class JwtValidators {
    private JwtValidators() {
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithIssuer(String issuer) {
        return JwtValidators.createDefaultWithValidators(new JwtIssuerValidator(issuer));
    }

    public static OAuth2TokenValidator<Jwt> createDefault() {
        return new DelegatingOAuth2TokenValidator(Arrays.asList(new JwtTimestampValidator(), new X509CertificateThumbprintValidator(X509CertificateThumbprintValidator.DEFAULT_X509_CERTIFICATE_SUPPLIER)));
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithValidators(List<OAuth2TokenValidator<Jwt>> validators) {
        JwtTimestampValidator jwtTimestampValidator;
        Assert.notEmpty(validators, (String)"validators cannot be null or empty");
        ArrayList<OAuth2TokenValidator<Jwt>> tokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>(validators);
        X509CertificateThumbprintValidator x509CertificateThumbprintValidator = (X509CertificateThumbprintValidator)CollectionUtils.findValueOfType(tokenValidators, X509CertificateThumbprintValidator.class);
        if (x509CertificateThumbprintValidator == null) {
            tokenValidators.add(0, new X509CertificateThumbprintValidator(X509CertificateThumbprintValidator.DEFAULT_X509_CERTIFICATE_SUPPLIER));
        }
        if ((jwtTimestampValidator = (JwtTimestampValidator)CollectionUtils.findValueOfType(tokenValidators, JwtTimestampValidator.class)) == null) {
            tokenValidators.add(0, new JwtTimestampValidator());
        }
        return new DelegatingOAuth2TokenValidator(tokenValidators);
    }

    public static OAuth2TokenValidator<Jwt> createDefaultWithValidators(OAuth2TokenValidator<Jwt> ... validators) {
        Assert.notEmpty((Object[])validators, (String)"validators cannot be null or empty");
        ArrayList<OAuth2TokenValidator<Jwt>> tokenValidators = new ArrayList<OAuth2TokenValidator<Jwt>>(Arrays.asList(validators));
        return JwtValidators.createDefaultWithValidators(tokenValidators);
    }
}

