/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public final class NimbusJwtDecoderJwkSupport
implements JwtDecoder {
    private static final String DECODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to decode the Jwt: %s";
    private final JWSAlgorithm jwsAlgorithm;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private final RestOperationsResourceRetriever jwkSetRetriever = new RestOperationsResourceRetriever();
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl) {
        this(jwkSetUrl, "RS256");
    }

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl, String jwsAlgorithm) {
        RemoteJWKSet jwkSource;
        Assert.hasText((String)jwkSetUrl, (String)"jwkSetUrl cannot be empty");
        Assert.hasText((String)jwsAlgorithm, (String)"jwsAlgorithm cannot be empty");
        try {
            jwkSource = new RemoteJWKSet(new URL(jwkSetUrl), (ResourceRetriever)this.jwkSetRetriever);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid JWK Set URL \"" + jwkSetUrl + "\" : " + ex.getMessage(), ex);
        }
        this.jwsAlgorithm = JWSAlgorithm.parse((String)jwsAlgorithm);
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(this.jwsAlgorithm, (JWKSource)jwkSource);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
        this.jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof SignedJWT) {
            Jwt createdJwt = this.createJwt(token, jwt);
            return this.validateJwt(createdJwt);
        }
        throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    public final void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
    }

    private Jwt createJwt(String token, JWT parsedJwt) {
        Jwt jwt;
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>((Map<String, Object>)parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            Instant expiresAt = (Instant)claims.get("exp");
            Instant issuedAt = (Instant)claims.get("iat");
            jwt = new Jwt(token, issuedAt, expiresAt, headers, claims);
        }
        catch (RemoteKeySourceException ex) {
            if (ex.getCause() instanceof ParseException) {
                throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed Jwk set"));
            }
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ParseException) {
                throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed payload"));
            }
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), ex);
        }
        return jwt;
    }

    private Jwt validateJwt(Jwt jwt) {
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((AbstractOAuth2Token)jwt);
        if (result.hasErrors()) {
            String description = ((OAuth2Error)result.getErrors().iterator().next()).getDescription();
            throw new JwtValidationException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, description), result.getErrors());
        }
        return jwt;
    }

    public final void setRestOperations(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.jwkSetRetriever.restOperations = restOperations;
    }

    private static class RestOperationsResourceRetriever
    implements ResourceRetriever {
        private RestOperations restOperations = new RestTemplate();

        private RestOperationsResourceRetriever() {
        }

        public Resource retrieveResource(URL url) throws IOException {
            ResponseEntity response;
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
            try {
                RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, url.toURI());
                response = this.restOperations.exchange(request, String.class);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            if (response.getStatusCodeValue() != 200) {
                throw new IOException(response.toString());
            }
            return new Resource((String)response.getBody(), "UTF-8");
        }
    }
}

