/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.json.BasicJsonParser;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.modulith.docs.DocumentationSource;
import org.springframework.modulith.docs.metadata.MethodMetadata;
import org.springframework.modulith.docs.metadata.TypeMetadata;
import org.springframework.modulith.docs.util.BuildSystemUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SpringModulithDocumentationSource
implements DocumentationSource {
    private static final String METADATA_FILE = "generated-spring-modulith/javadoc.json";
    private static final Optional<DocumentationSource> INSTANCE = BuildSystemUtils.getTargetResource("generated-spring-modulith/javadoc.json").map(SpringModulithDocumentationSource::new);
    private Collection<TypeMetadata> metadata;

    private SpringModulithDocumentationSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null!");
        this.metadata = SpringModulithDocumentationSource.from(resource);
    }

    public static Optional<DocumentationSource> getInstance() {
        return INSTANCE;
    }

    public static String getMetadataLocation() {
        return METADATA_FILE;
    }

    @Override
    public Optional<String> getDocumentation(JavaClass type) {
        return this.metadata.stream().filter(it -> it.name().equals(type.getName())).findFirst().map(TypeMetadata::comment).filter(StringUtils::hasText);
    }

    @Override
    public Optional<String> getDocumentation(JavaMethod method) {
        JavaClass owner = method.getOwner();
        return this.metadata.stream().filter(it -> it.name().equals(owner.getName())).findFirst().stream().flatMap(it -> it.methods().stream()).filter(it -> it.hasSignatureOf(method.reflect())).findFirst().map(MethodMetadata::comment).filter(StringUtils::hasText);
    }

    private static Collection<TypeMetadata> from(Resource resource) {
        try {
            String content = resource.getContentAsString(StandardCharsets.UTF_8);
            List parsed = new BasicJsonParser().parseList(content);
            return parsed.stream().map(it -> {
                TypeMetadata metadata;
                return it instanceof TypeMetadata ? (metadata = (TypeMetadata)it) : SpringModulithDocumentationSource.typeMetadata((Map)it);
            }).toList();
        }
        catch (IOException o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private static TypeMetadata typeMetadata(Map<String, Object> source) {
        List<MethodMetadata> methods = source.containsKey("methods") ? ((List)source.get("methods")).stream().map(SpringModulithDocumentationSource::methodMetadata).toList() : Collections.emptyList();
        return new TypeMetadata(source.get("name").toString(), SpringModulithDocumentationSource.getString(source, "comment"), methods);
    }

    private static MethodMetadata methodMetadata(Map<String, Object> source) {
        return new MethodMetadata(source.get("name").toString(), source.get("signature").toString(), SpringModulithDocumentationSource.getString(source, "comment"));
    }

    @Nullable
    private static String getString(Map<String, Object> source, String key) {
        Object result = source.get(key);
        return result == null ? null : result.toString();
    }
}

