/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.util.Pair;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class LocationRewriteFilter
extends ZuulFilter {
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    @Autowired
    private ZuulProperties zuulProperties;
    @Autowired
    private RouteLocator routeLocator;
    private static final String LOCATION_HEADER = "Location";

    public LocationRewriteFilter() {
    }

    public LocationRewriteFilter(ZuulProperties zuulProperties, RouteLocator routeLocator) {
        this.routeLocator = routeLocator;
        this.zuulProperties = zuulProperties;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 900;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        int statusCode = ctx.getResponseStatusCode();
        return HttpStatus.valueOf((int)statusCode).is3xxRedirection();
    }

    public Object run() {
        Pair<String, String> lh;
        RequestContext ctx = RequestContext.getCurrentContext();
        Route route = this.routeLocator.getMatchingRoute(this.urlPathHelper.getPathWithinApplication(ctx.getRequest()));
        if (route != null && (lh = this.locationHeader(ctx)) != null) {
            String location = (String)lh.second();
            URI originalRequestUri = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(ctx.getRequest())).build().toUri();
            UriComponentsBuilder redirectedUriBuilder = UriComponentsBuilder.fromUriString((String)location);
            UriComponents redirectedUriComps = redirectedUriBuilder.build();
            String newPath = this.getRestoredPath(this.zuulProperties, route, redirectedUriComps);
            String modifiedLocation = redirectedUriBuilder.scheme(originalRequestUri.getScheme()).host(originalRequestUri.getHost()).port(originalRequestUri.getPort()).replacePath(newPath).build().toUriString();
            lh.setSecond((Object)modifiedLocation);
        }
        return null;
    }

    private String getRestoredPath(ZuulProperties zuulProperties, Route route, UriComponents redirectedUriComps) {
        String redirectedPathWithoutGlobal;
        StringBuilder path = new StringBuilder();
        String string = redirectedPathWithoutGlobal = this.downstreamHasGlobalPrefix(zuulProperties) ? redirectedUriComps.getPath().substring(("/" + zuulProperties.getPrefix()).length()) : redirectedUriComps.getPath();
        if (this.downstreamHasGlobalPrefix(zuulProperties)) {
            path.append("/").append(zuulProperties.getPrefix());
        } else {
            path.append(this.zuulHasGlobalPrefix(zuulProperties) ? "/" + zuulProperties.getPrefix() : "");
        }
        path.append(this.downstreamHasRoutePrefix(route) ? "" : "/" + route.getPrefix()).append(redirectedPathWithoutGlobal);
        return path.toString();
    }

    private boolean downstreamHasGlobalPrefix(ZuulProperties zuulProperties) {
        return !zuulProperties.isStripPrefix() && StringUtils.hasText((String)zuulProperties.getPrefix());
    }

    private boolean zuulHasGlobalPrefix(ZuulProperties zuulProperties) {
        return StringUtils.hasText((String)zuulProperties.getPrefix());
    }

    private boolean downstreamHasRoutePrefix(Route route) {
        return !route.isPrefixStripped() && StringUtils.hasText((String)route.getPrefix());
    }

    private Pair<String, String> locationHeader(RequestContext ctx) {
        if (ctx.getZuulResponseHeaders() != null) {
            for (Pair pair : ctx.getZuulResponseHeaders()) {
                if (!((String)pair.first()).equals(LOCATION_HEADER)) continue;
                return pair;
            }
        }
        return null;
    }
}

