/*
 * Copyright 2012-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.bus.event;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;

/**
 * @author Spencer Gibb
 * @author Ryan Baxter
 */
public class RefreshListener
		implements ApplicationListener<RefreshRemoteApplicationEvent> {

	private static Log log = LogFactory.getLog(RefreshListener.class);

	private ContextRefresher contextRefresher;

	private ServiceMatcher serviceMatcher;

	@Deprecated
	// TODO Remove in 3.0.x
	public RefreshListener(ContextRefresher contextRefresher) {
		this(contextRefresher, null);
	}

	public RefreshListener(ContextRefresher contextRefresher,
			ServiceMatcher serviceMatcher) {
		this.contextRefresher = contextRefresher;
		this.serviceMatcher = serviceMatcher;
	}

	@Override
	public void onApplicationEvent(RefreshRemoteApplicationEvent event) {
		log.info("Received remote refresh request.");
		// TODO Remove this in 3.0.x
		if (serviceMatcher == null) {
			log.warn(
					"RefreshListener does not have a ServiceMatcher, refresh may be performed even if "
							+ "the event does not target this app.  Consider passing a ServiceMatcher in "
							+ "the constructor");
			refresh();
		}
		else if (serviceMatcher.isForSelf(event)) {
			refresh();
		}
		else {
			log.info("Refresh not performed, the event was targetting "
					+ event.getDestinationService());
		}
	}

	private void refresh() {
		Set<String> keys = this.contextRefresher.refresh();
		log.info("Keys refreshed " + keys);
	}

}
