/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.springframework.boot.buildpack.platform.build.BuilderDockerConfiguration;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerRegistryAuthentication;

public abstract class DockerSpec {
    private final DockerRegistrySpec builderRegistry;
    private final DockerRegistrySpec publishRegistry;

    @Inject
    public DockerSpec(ObjectFactory objects) {
        this.builderRegistry = (DockerRegistrySpec)objects.newInstance(DockerRegistrySpec.class, new Object[0]);
        this.publishRegistry = (DockerRegistrySpec)objects.newInstance(DockerRegistrySpec.class, new Object[0]);
        this.getBindHostToBuilder().convention((Object)false);
        this.getTlsVerify().convention((Object)false);
    }

    DockerSpec(DockerRegistrySpec builderRegistry, DockerRegistrySpec publishRegistry) {
        this.builderRegistry = builderRegistry;
        this.publishRegistry = publishRegistry;
    }

    @Input
    @Optional
    public abstract Property<String> getContext();

    @Input
    @Optional
    public abstract Property<String> getHost();

    @Input
    @Optional
    public abstract Property<Boolean> getTlsVerify();

    @Input
    @Optional
    public abstract Property<String> getCertPath();

    @Input
    @Optional
    public abstract Property<Boolean> getBindHostToBuilder();

    @Nested
    public DockerRegistrySpec getBuilderRegistry() {
        return this.builderRegistry;
    }

    public void builderRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.builderRegistry);
    }

    @Nested
    public DockerRegistrySpec getPublishRegistry() {
        return this.publishRegistry;
    }

    public void publishRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.publishRegistry);
    }

    BuilderDockerConfiguration asDockerConfiguration() {
        BuilderDockerConfiguration dockerConfiguration = new BuilderDockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = dockerConfiguration.withBindHostToBuilder(((Boolean)this.getBindHostToBuilder().get()).booleanValue());
        dockerConfiguration = this.customizeBuilderAuthentication(dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(dockerConfiguration);
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeHost(BuilderDockerConfiguration dockerConfiguration) {
        String context = (String)this.getContext().getOrNull();
        String host = (String)this.getHost().getOrNull();
        if (context != null && host != null) {
            throw new GradleException("Invalid Docker configuration, either context or host can be provided but not both");
        }
        if (context != null) {
            return dockerConfiguration.withContext(context);
        }
        if (host != null) {
            return dockerConfiguration.withHost(host, ((Boolean)this.getTlsVerify().get()).booleanValue(), (String)this.getCertPath().getOrNull());
        }
        return dockerConfiguration;
    }

    private BuilderDockerConfiguration customizeBuilderAuthentication(BuilderDockerConfiguration dockerConfiguration) {
        return dockerConfiguration.withBuilderRegistryAuthentication(this.getRegistryAuthentication("builder", this.builderRegistry, DockerRegistryAuthentication.configuration(null)));
    }

    private BuilderDockerConfiguration customizePublishAuthentication(BuilderDockerConfiguration dockerConfiguration) {
        return dockerConfiguration.withPublishRegistryAuthentication(this.getRegistryAuthentication("publish", this.publishRegistry, DockerRegistryAuthentication.configuration((DockerRegistryAuthentication)DockerRegistryAuthentication.EMPTY_USER)));
    }

    private DockerRegistryAuthentication getRegistryAuthentication(String type, DockerRegistrySpec registry, DockerRegistryAuthentication fallback) {
        if (registry == null || registry.hasEmptyAuth()) {
            return fallback;
        }
        if (registry.hasTokenAuth() && !registry.hasUserAuth()) {
            return DockerRegistryAuthentication.token((String)((String)registry.getToken().get()));
        }
        if (registry.hasUserAuth() && !registry.hasTokenAuth()) {
            return DockerRegistryAuthentication.user((String)((String)registry.getUsername().get()), (String)((String)registry.getPassword().get()), (String)((String)registry.getUrl().getOrNull()), (String)((String)registry.getEmail().getOrNull()));
        }
        throw new GradleException("Invalid Docker " + type + " registry configuration, either token or username/password must be provided");
    }

    public static abstract class DockerRegistrySpec {
        @Input
        @Optional
        public abstract Property<String> getUsername();

        @Input
        @Optional
        public abstract Property<String> getPassword();

        @Input
        @Optional
        public abstract Property<String> getUrl();

        @Input
        @Optional
        public abstract Property<String> getEmail();

        @Input
        @Optional
        public abstract Property<String> getToken();

        boolean hasEmptyAuth() {
            return this.nonePresent(this.getUsername(), this.getPassword(), this.getUrl(), this.getEmail(), this.getToken());
        }

        private boolean nonePresent(Property<?> ... properties) {
            for (Property<?> property : properties) {
                if (!property.isPresent()) continue;
                return false;
            }
            return true;
        }

        boolean hasUserAuth() {
            return this.allPresent(this.getUsername(), this.getPassword());
        }

        private boolean allPresent(Property<?> ... properties) {
            for (Property<?> property : properties) {
                if (property.isPresent()) continue;
                return false;
            }
            return true;
        }

        boolean hasTokenAuth() {
            return this.getToken().isPresent();
        }
    }
}

