/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LoaderZipEntries;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.FileUtils;

class BootZipCopyAction
implements CopyAction {
    static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();
    private final File output;
    private final boolean preserveFileTimestamps;
    private final boolean includeDefaultLoader;
    private final Spec<FileTreeElement> requiresUnpack;
    private final Spec<FileTreeElement> exclusions;
    private final LaunchScriptConfiguration launchScript;
    private final Function<FileCopyDetails, ZipCompression> compressionResolver;
    private final String encoding;

    BootZipCopyAction(File output, boolean preserveFileTimestamps, boolean includeDefaultLoader, Spec<FileTreeElement> requiresUnpack, Spec<FileTreeElement> exclusions, LaunchScriptConfiguration launchScript, Function<FileCopyDetails, ZipCompression> compressionResolver, String encoding) {
        this.output = output;
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.includeDefaultLoader = includeDefaultLoader;
        this.requiresUnpack = requiresUnpack;
        this.exclusions = exclusions;
        this.launchScript = launchScript;
        this.compressionResolver = compressionResolver;
        this.encoding = encoding;
    }

    public WorkResult execute(CopyActionProcessingStream stream) {
        try {
            this.writeArchive(stream);
            return () -> true;
        }
        catch (IOException ex) {
            throw new GradleException("Failed to create " + this.output, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArchive(CopyActionProcessingStream stream) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(this.output);
        try {
            this.writeLaunchScriptIfNecessary(outputStream);
            ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)outputStream);
            try {
                if (this.encoding != null) {
                    zipOutputStream.setEncoding(this.encoding);
                }
                Processor processor = new Processor(zipOutputStream);
                stream.process(processor::process);
                processor.finish();
            }
            finally {
                this.closeQuietly((OutputStream)zipOutputStream);
            }
        }
        finally {
            this.closeQuietly(outputStream);
        }
    }

    private void writeLaunchScriptIfNecessary(OutputStream outputStream) {
        if (this.launchScript == null) {
            return;
        }
        try {
            File file = this.launchScript.getScript();
            Map<String, String> properties = this.launchScript.getProperties();
            outputStream.write(new DefaultLaunchScript(file, properties).toByteArray());
            outputStream.flush();
            this.output.setExecutable(true);
        }
        catch (IOException ex) {
            throw new GradleException("Failed to write launch script to " + this.output, (Throwable)ex);
        }
    }

    private void closeQuietly(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc = new CRC32();

        private Crc32OutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.crc.update(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.crc.update(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.crc.update(b, off, len);
        }

        private long getCrc() {
            return this.crc.getValue();
        }
    }

    private class Processor {
        private ZipArchiveOutputStream outputStream;
        private Spec<FileTreeElement> writtenLoaderEntries;

        Processor(ZipArchiveOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        void process(FileCopyDetails details) {
            if (BootZipCopyAction.this.exclusions.isSatisfiedBy((Object)details) || this.writtenLoaderEntries != null && this.writtenLoaderEntries.isSatisfiedBy((Object)details)) {
                return;
            }
            try {
                this.writeLoaderEntriesIfNecessary(details);
                if (details.isDirectory()) {
                    this.processDirectory(details);
                } else {
                    this.processFile(details);
                }
            }
            catch (IOException ex) {
                throw new GradleException("Failed to add " + details + " to " + BootZipCopyAction.this.output, (Throwable)ex);
            }
        }

        void finish() throws IOException {
            this.writeLoaderEntriesIfNecessary(null);
        }

        private void writeLoaderEntriesIfNecessary(FileCopyDetails details) throws IOException {
            if (!BootZipCopyAction.this.includeDefaultLoader || this.writtenLoaderEntries != null) {
                return;
            }
            if (this.isInMetaInf(details)) {
                return;
            }
            LoaderZipEntries loaderEntries = new LoaderZipEntries(BootZipCopyAction.this.preserveFileTimestamps ? null : Long.valueOf(CONSTANT_TIME_FOR_ZIP_ENTRIES));
            this.writtenLoaderEntries = loaderEntries.writeTo(this.outputStream);
        }

        private boolean isInMetaInf(FileCopyDetails details) {
            if (details == null) {
                return false;
            }
            String[] segments = details.getRelativePath().getSegments();
            return segments.length > 0 && "META-INF".equals(segments[0]);
        }

        private void processDirectory(FileCopyDetails details) throws IOException {
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry(details.getRelativePath().getPathString() + '/');
            archiveEntry.setUnixMode(0x4000 | details.getMode());
            archiveEntry.setTime(this.getTime(details));
            this.outputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
            this.outputStream.closeArchiveEntry();
        }

        private void processFile(FileCopyDetails details) throws IOException {
            String relativePath = details.getRelativePath().getPathString();
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry(relativePath);
            archiveEntry.setUnixMode(0x8000 | details.getMode());
            archiveEntry.setTime(this.getTime(details));
            ZipCompression compression = (ZipCompression)((Object)BootZipCopyAction.this.compressionResolver.apply(details));
            if (compression == ZipCompression.STORED) {
                this.prepareStoredEntry(details, archiveEntry);
            }
            this.outputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
            details.copyTo((OutputStream)this.outputStream);
            this.outputStream.closeArchiveEntry();
        }

        private void prepareStoredEntry(FileCopyDetails details, ZipArchiveEntry archiveEntry) throws IOException {
            archiveEntry.setMethod(0);
            archiveEntry.setSize(details.getSize());
            archiveEntry.setCompressedSize(details.getSize());
            Crc32OutputStream crcStream = new Crc32OutputStream();
            details.copyTo((OutputStream)crcStream);
            archiveEntry.setCrc(crcStream.getCrc());
            if (BootZipCopyAction.this.requiresUnpack.isSatisfiedBy((Object)details)) {
                archiveEntry.setComment("UNPACK:" + FileUtils.sha1Hash((File)details.getFile()));
            }
        }

        private long getTime(FileCopyDetails details) {
            return BootZipCopyAction.this.preserveFileTimestamps ? details.getLastModified() : CONSTANT_TIME_FOR_ZIP_ENTRIES;
        }
    }
}

