/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import java.util.Objects;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;

public final class ItemIgnore
implements Comparable<ItemIgnore> {
    private final ItemMetadata.ItemType type;
    private final String name;

    private ItemIgnore(ItemMetadata.ItemType type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("'type' must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("'name' must not be null");
        }
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ItemMetadata.ItemType getType() {
        return this.type;
    }

    @Override
    public int compareTo(ItemIgnore other) {
        return this.getName().compareTo(other.getName());
    }

    public static ItemIgnore forProperty(String name) {
        return new ItemIgnore(ItemMetadata.ItemType.PROPERTY, name);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIgnore that = (ItemIgnore)o;
        return this.type == that.type && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return "ItemIgnore{type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "'}";
    }
}

