/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.docker.ProgressUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.PullImageUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressBar;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;

public class TotalProgressPullListener
implements UpdateListener<PullImageUpdateEvent> {
    private final Map<String, Layer> layers = new ConcurrentHashMap<String, Layer>();
    private final Consumer<TotalProgressEvent> consumer;
    private boolean progressStarted;

    public TotalProgressPullListener(String prefix) {
        this(new TotalProgressBar(prefix));
    }

    public TotalProgressPullListener(Consumer<TotalProgressEvent> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onUpdate(PullImageUpdateEvent event) {
        if (event.getId() != null) {
            this.layers.computeIfAbsent(event.getId(), Layer::new).update(event);
        }
        boolean bl = this.progressStarted = this.progressStarted || event.getProgress() != null;
        if (this.progressStarted) {
            this.publish(0);
        }
    }

    @Override
    public void onFinish() {
        this.layers.values().forEach(Layer::finish);
        this.publish(100);
    }

    private void publish(int fallback) {
        int count = 0;
        int total = 0;
        for (Layer layer : this.layers.values()) {
            ++count;
            total += layer.getProgress();
        }
        TotalProgressEvent event = new TotalProgressEvent(count != 0 ? TotalProgressPullListener.withinPercentageBounds(total / count) : fallback);
        this.consumer.accept(event);
    }

    private static int withinPercentageBounds(int value) {
        if (value < 0) {
            return 0;
        }
        return Math.min(value, 100);
    }

    private static class Layer {
        private int downloadProgress;
        private int extractProgress;

        Layer(String id) {
        }

        void update(PullImageUpdateEvent event) {
            if (event.getProgressDetail() != null) {
                ProgressUpdateEvent.ProgressDetail detail = event.getProgressDetail();
                if ("Downloading".equals(event.getStatus())) {
                    this.downloadProgress = this.updateProgress(this.downloadProgress, detail);
                }
                if ("Extracting".equals(event.getStatus())) {
                    this.extractProgress = this.updateProgress(this.extractProgress, detail);
                }
            }
        }

        private int updateProgress(int current, ProgressUpdateEvent.ProgressDetail detail) {
            int result = TotalProgressPullListener.withinPercentageBounds((int)(100.0 / (double)detail.getTotal() * (double)detail.getCurrent()));
            return Math.max(result, current);
        }

        void finish() {
            this.downloadProgress = 100;
            this.extractProgress = 100;
        }

        int getProgress() {
            return TotalProgressPullListener.withinPercentageBounds((this.downloadProgress + this.extractProgress) / 2);
        }
    }
}

