/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import org.springframework.util.Assert;

public class ImageName {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String OFFICIAL_REPOSITORY_NAME = "library";
    private static final String LEGACY_DOMAIN = "index.docker.io";
    private final String domain;
    private final String name;
    private final String string;

    ImageName(String domain, String name) {
        Assert.hasText((String)domain, (String)"Domain must not be empty");
        Assert.hasText((String)name, (String)"Name must not be empty");
        this.domain = domain;
        this.name = name;
        this.string = domain + "/" + name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageName other = (ImageName)obj;
        boolean result = true;
        result = result && this.domain.equals(other.domain);
        result = result && this.name.equals(other.name);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.string;
    }

    public String toLegacyString() {
        if (DEFAULT_DOMAIN.equals(this.domain)) {
            return "index.docker.io/" + this.name;
        }
        return this.string;
    }

    public static ImageName of(String value) {
        String[] split = ImageName.split(value);
        return new ImageName(split[0], split[1]);
    }

    static String[] split(String value) {
        String firstSegment;
        Assert.hasText((String)value, (String)"Value must not be empty");
        String domain = DEFAULT_DOMAIN;
        int firstSlash = value.indexOf(47);
        if (firstSlash != -1 && ((firstSegment = value.substring(0, firstSlash)).contains(".") || firstSegment.contains(":") || "localhost".equals(firstSegment))) {
            domain = LEGACY_DOMAIN.equals(firstSegment) ? DEFAULT_DOMAIN : firstSegment;
            value = value.substring(firstSlash + 1);
        }
        if (DEFAULT_DOMAIN.equals(domain) && !value.contains("/")) {
            value = "library/" + value;
        }
        return new String[]{domain, value};
    }
}

