/*
 * 
 *  This file is part of XmlParser.
 *
 *  Foobar is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Foobar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package org.sourceprojects.xmlparserspringintegration;

import org.sourceprojects.xmlparser.ResourceResolver;
import org.sourceprojects.xmlparser.ResourceResolverFactory;
import org.springframework.beans.factory.FactoryBean;

public class ResourceResolverSpringFactory implements FactoryBean {

	public Object getObject() throws Exception {
		return ResourceResolverFactory.newInstance(getClass().getClassLoader());
	}

	public Class getObjectType() {
		return ResourceResolver.class;
	}

	public boolean isSingleton() {
		return false;
	}

}
