/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.xquery.saxon.arq;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetRewindable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceforge.xsparql.sparql.arq.DatasetResults;
import org.sourceforge.xsparql.sparql.arq.InMemoryDatasetManager;

class ScopedDatasetManager {
    private static Map<String, DatasetResults> scopedDataset = new HashMap<String, DatasetResults>();
    private static InMemoryDatasetManager inMemoryDataset = null;

    ScopedDatasetManager() {
    }

    public static ResultSet createScopedDataset(String q, String id) {
        if (scopedDataset.containsKey(id)) {
            // empty if block
        }
        Query query = QueryFactory.create((String)q);
        Dataset dataset = DatasetFactory.create((List)query.getGraphURIs(), (List)query.getNamedGraphURIs());
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        ResultSet resultSet = qe.execSelect();
        DatasetResults ds = new DatasetResults(dataset);
        ResultSetRewindable results = ds.addResults(resultSet);
        scopedDataset.put(id, ds);
        return results;
    }

    public static ResultSet sparqlScopedDataset(String q, String id, String joinVars, int pos) {
        if (!scopedDataset.containsKey(id)) {
            // empty if block
        }
        Dataset dataset = scopedDataset.get(id).getDataset();
        ResultSetRewindable results = scopedDataset.get(id).getResults();
        results.reset();
        QuerySolutionMap initialBinding = ScopedDatasetManager.createSolutionMap(results, joinVars, pos);
        QueryExecution qe = QueryExecutionFactory.create((String)q, (Dataset)dataset, (QuerySolution)initialBinding);
        ResultSet resultSet = qe.execSelect();
        ResultSetRewindable results2 = scopedDataset.get(id).addResults(resultSet);
        return results2;
    }

    private static QuerySolutionMap createSolutionMap(ResultSetRewindable results, String joinVars, int pos) {
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        String[] joinVarsArray = joinVars.split(",");
        QuerySolutionMap s = new QuerySolutionMap();
        int it = 1;
        while (results.hasNext()) {
            QuerySolution qs = results.next();
            if (it == pos) {
                s = qs;
                break;
            }
            ++it;
        }
        for (String st : Arrays.asList(joinVarsArray)) {
            if (!s.contains(st)) continue;
            initialBinding.add(st, s.get(st));
        }
        return initialBinding;
    }

    public static void deleteScopedDataset(String id) {
        scopedDataset.remove(id);
    }

    public static void scopedDatasetPopResults(String id) {
        if (scopedDataset.size() > 0) {
            scopedDataset.get(id).popResults();
        }
    }
}

