/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.sparql.arq;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import org.sourceforge.xsparql.rewriter.Helper;
import org.w3c.dom.Document;

public class SPARQLQuery {
    private String query;
    private Dataset dataset = null;

    public SPARQLQuery(String query) {
        this.query = query;
        this.dataset = null;
    }

    public SPARQLQuery(String query, Dataset dataset) {
        this.query = query;
        this.dataset = dataset;
    }

    public ResultSet getResults() {
        QueryExecution qe;
        Query q = QueryFactory.create((String)this.query);
        if (this.dataset == null) {
            qe = QueryExecutionFactory.create((Query)q);
            if (qe.getQuery().getDatasetDescription() == null) {
                qe = QueryExecutionFactory.create((Query)q, (Dataset)DatasetFactory.createMem());
            }
        } else {
            qe = QueryExecutionFactory.create((String)this.query, (Dataset)this.dataset);
        }
        return qe.execSelect();
    }

    public Document getResultsAsXML() {
        ResultSet resultSet = this.getResults();
        String xml = ResultSetFormatter.asXMLString((ResultSet)resultSet);
        return Helper.parseXMLString((String)xml);
    }
}

