/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.xsparql.sparql.arq;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.net.URL;
import java.util.Set;
import org.apache.jena.riot.RDFDataMgr;
import org.sourceforge.xsparql.sparql.DatasetManager;

public class InMemoryDatasetManager
implements DatasetManager {
    public static final InMemoryDatasetManager INSTANCE = new InMemoryDatasetManager();
    private Dataset inMemoryDataset = DatasetFactory.createMem();
    private boolean emptyDataset = true;

    private InMemoryDatasetManager() {
    }

    public void clean() {
        this.inMemoryDataset.close();
        this.inMemoryDataset = DatasetFactory.createMem();
        this.emptyDataset = true;
    }

    public void setDataset(Set<URL> defaultGraph, Set<URL> namedGraphs) {
        Model dModel = ModelFactory.createDefaultModel();
        if (defaultGraph != null && defaultGraph.size() > 0) {
            this.emptyDataset = false;
            for (URL f : defaultGraph) {
                dModel.add(RDFDataMgr.loadModel((String)f.toString()));
            }
            this.inMemoryDataset.setDefaultModel(dModel);
        }
        if (namedGraphs != null && namedGraphs.size() > 0) {
            this.emptyDataset = false;
            for (URL f : namedGraphs) {
                this.inMemoryDataset.addNamedModel(f.toString(), RDFDataMgr.loadModel((String)f.toString()));
            }
        }
    }

    public Dataset getDataset() {
        return this.inMemoryDataset;
    }

    public boolean isEmpty() {
        return this.emptyDataset;
    }
}

