/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.Objects;
import java.util.function.Predicate;
import org.solidcoding.validation.api.ChainingPredicate;
import org.solidcoding.validation.predicates.PredicateContainer;
import org.solidcoding.validation.predicates.StringLengthConstraintPredicateBuilder;

public final class StringPredicateBuilder
extends PredicateContainer<String> {
    private StringPredicateBuilder() {
    }

    private StringPredicateBuilder(Predicate<String> rule) {
        this.addPredicate(rule);
    }

    public static Predicate<String> contains(CharSequence value, CharSequence ... values) {
        return StringPredicateBuilder.contains(value, values);
    }

    public static Predicate<String> doesNotContain(CharSequence value, CharSequence ... values) {
        return StringPredicateBuilder.doesNotContain(value, values);
    }

    public static Predicate<String> is(String value) {
        return new StringPredicateBuilder(StringPredicateBuilder.is((String x) -> Objects.equals(x, value)));
    }

    public static Predicate<String> is(Predicate<String> rule) {
        return new StringPredicateBuilder(rule);
    }

    public static ChainingPredicate<Integer, Predicate<String>> hasALengthBetween(int length) {
        return new StringLengthConstraintPredicateBuilder(length, new StringPredicateBuilder());
    }

    public static Predicate<String> hasALengthOf(int length) {
        return StringPredicateBuilder.is((String x) -> x.length() == length);
    }

    public static Predicate<String> isNumeric() {
        return StringPredicateBuilder.is((String x) -> x.chars().allMatch(Character::isDigit));
    }

    public static Predicate<String> isNotNumeric() {
        return StringPredicateBuilder.is((String x) -> x.chars().anyMatch(Character::isAlphabetic));
    }

    public static Predicate<String> isAlphabetic() {
        return StringPredicateBuilder.is((String x) -> x.chars().allMatch(Character::isAlphabetic));
    }

    public static Predicate<String> isNotAlphabetic() {
        return StringPredicateBuilder.is((String x) -> x.chars().anyMatch(Character::isDigit));
    }
}

