/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.solidcoding.validation.predicates.GenericPredicate;

class PredicateContainer<T>
implements GenericPredicate<T> {
    private final List<Predicate<T>> rules = new ArrayList<Predicate<T>>();

    PredicateContainer() {
    }

    PredicateContainer(List<Predicate<T>> rules) {
        this.rules.addAll(rules);
    }

    void addPredicate(Predicate<T> predicate) {
        this.rules.add(predicate);
    }

    @Override
    public boolean test(T value) {
        return this.rules.stream().allMatch(x -> x.test(value));
    }

    @Override
    public Predicate<T> where(Predicate<T> rule) {
        this.addPredicate(rule);
        return this;
    }

    static <T> GenericPredicate<T> contains(Object value, Object ... values) {
        ArrayList<Predicate<T>> rules = new ArrayList<Predicate<T>>();
        rules.add(x -> x.toString().contains(value.toString()));
        for (Object v : values) {
            rules.add(x -> x.toString().contains(v.toString()));
        }
        return new PredicateContainer<T>(rules);
    }

    static <T> GenericPredicate<T> doesNotContain(Object value, Object ... values) {
        ArrayList<Predicate<T>> rules = new ArrayList<Predicate<T>>();
        rules.add(x -> !x.toString().contains(value.toString()));
        for (Object v : values) {
            rules.add(x -> !x.toString().contains(v.toString()));
        }
        return new PredicateContainer<T>(rules);
    }
}

