/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.function.Predicate;
import org.solidcoding.validation.api.ChainingPredicate;
import org.solidcoding.validation.predicates.NumberConstraintPredicateBuilder;
import org.solidcoding.validation.predicates.NumberPredicate;
import org.solidcoding.validation.predicates.PredicateContainer;

public final class NumberPredicateBuilder
extends PredicateContainer<Integer>
implements NumberPredicate {
    private NumberPredicateBuilder() {
    }

    private NumberPredicateBuilder(Predicate<Integer> rule) {
        this.addPredicate(rule);
    }

    public static NumberPredicate is() {
        return new NumberPredicateBuilder();
    }

    public static Predicate<Integer> is(int value) {
        return new NumberPredicateBuilder(x -> x == value);
    }

    public static Predicate<Integer> hasAmountOfDigits(int amountOfDigits) {
        return new NumberPredicateBuilder(x -> String.valueOf(x).length() == amountOfDigits);
    }

    public static Predicate<Integer> contains(Integer value, Integer ... values) {
        return PredicateContainer.contains(value, values);
    }

    public static Predicate<Integer> doesNotContain(Integer value, Integer ... values) {
        return PredicateContainer.doesNotContain(value, values);
    }

    @Override
    public ChainingPredicate<Integer, Predicate<Integer>> between(int first) {
        return new NumberConstraintPredicateBuilder(first, this);
    }
}

