/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.solidcoding.validation.api.ChainingPredicate;
import org.solidcoding.validation.predicates.DecimalNumberConstraintPredicate;
import org.solidcoding.validation.predicates.DecimalNumberPredicate;
import org.solidcoding.validation.predicates.PredicateContainer;

public final class DecimalNumberPredicateBuilder
extends PredicateContainer<Double>
implements DecimalNumberPredicate {
    private DecimalNumberPredicateBuilder() {
    }

    private DecimalNumberPredicateBuilder(Predicate<Double> rule) {
        this.addPredicate(rule);
    }

    private DecimalNumberPredicateBuilder(List<Predicate<Double>> rules) {
        rules.forEach(this::addPredicate);
    }

    public static DecimalNumberPredicate is() {
        return new DecimalNumberPredicateBuilder();
    }

    public static DecimalNumberPredicate is(double value) {
        return new DecimalNumberPredicateBuilder(x -> x == value);
    }

    public static DecimalNumberPredicate is(Predicate<Double> rule) {
        return new DecimalNumberPredicateBuilder(rule);
    }

    public static DecimalNumberPredicate contains(Integer value, Integer ... values) {
        ArrayList<Predicate<Double>> rules = new ArrayList<Predicate<Double>>();
        rules.add(x -> x.toString().contains(value.toString()));
        for (Integer c : values) {
            rules.add(x -> x.toString().contains(c.toString()));
        }
        return new DecimalNumberPredicateBuilder((List<Predicate<Double>>)rules);
    }

    public static DecimalNumberPredicate doesNotContain(Integer value, Integer ... values) {
        ArrayList<Predicate<Double>> rules = new ArrayList<Predicate<Double>>();
        rules.add(x -> !x.toString().contains(value.toString()));
        for (Integer c : values) {
            rules.add(x -> !x.toString().contains(c.toString()));
        }
        return new DecimalNumberPredicateBuilder((List<Predicate<Double>>)rules);
    }

    @Override
    public ChainingPredicate<Double, Predicate<Double>> between(double first) {
        return new DecimalNumberConstraintPredicate(first, this);
    }
}

