/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.predicates;

import java.util.function.Predicate;
import org.solidcoding.validation.api.ChainingPredicate;
import org.solidcoding.validation.predicates.PredicateContainer;

final class DecimalNumberConstraintPredicate
implements ChainingPredicate<Double, Predicate<Double>> {
    private final PredicateContainer<Double> originalPredicate;
    private final double first;

    DecimalNumberConstraintPredicate(Double first, PredicateContainer<Double> originalPredicate) {
        this.first = first;
        this.originalPredicate = originalPredicate;
    }

    @Override
    public Predicate<Double> and(Double second) {
        if (second > this.first) {
            this.originalPredicate.addPredicate(x -> x <= second && x >= this.first);
        } else {
            this.originalPredicate.addPredicate(x -> x <= this.first && x >= second);
        }
        return this.originalPredicate;
    }
}

