/*
 * Decompiled with CFR 0.152.
 */
package org.solidcoding.validation.api;

import java.util.function.Function;
import java.util.function.Supplier;
import org.solidcoding.validation.api.AbstractLoggingValidator;
import org.solidcoding.validation.api.ContinuingValidator;
import org.solidcoding.validation.api.ReturningValidator;

final class EndingValidator<T, R>
extends AbstractLoggingValidator<T>
implements ReturningValidator<R> {
    private final Supplier<R> supplier;

    EndingValidator(Supplier<R> supplier, ContinuingValidator<T> validator) {
        super(validator);
        this.supplier = supplier;
    }

    @Override
    public <E extends RuntimeException> R orElseThrow(Function<String, E> throwableFunction) {
        boolean isValid = this.validator.validate();
        if (!isValid) {
            throw (RuntimeException)throwableFunction.apply(this.validator.getMessage());
        }
        return this.supplier.get();
    }

    @Override
    public R orElseReturn(R other) {
        boolean isValid = this.validator.validate();
        if (!isValid) {
            return other;
        }
        return this.supplier.get();
    }

    @Override
    public R orElseReturn(Function<String, R> other) {
        boolean isValid = this.validator.validate();
        String message = this.validator.getMessage();
        if (!isValid) {
            return other.apply(message);
        }
        return this.supplier.get();
    }
}

