/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.CharacterUtils;
import org.simdjson.DoubleParser;
import org.simdjson.ExponentParser;
import org.simdjson.FloatParser;
import org.simdjson.JsonParsingException;
import org.simdjson.Tape;

class NumberParser {
    private static final int BYTE_MAX_DIGIT_COUNT = 3;
    private static final int BYTE_MAX_ABS_VALUE = 128;
    private static final int SHORT_MAX_DIGIT_COUNT = 5;
    private static final int SHORT_MAX_ABS_VALUE = 32768;
    private static final int INT_MAX_DIGIT_COUNT = 10;
    private static final long INT_MAX_ABS_VALUE = 0x80000000L;
    private static final int LONG_MAX_DIGIT_COUNT = 19;
    private final DigitsParsingResult digitsParsingResult = new DigitsParsingResult();
    private final ExponentParser exponentParser = new ExponentParser();
    private final DoubleParser doubleParser = new DoubleParser();
    private final FloatParser floatParser = new FloatParser();

    NumberParser() {
    }

    void parseNumber(byte[] buffer, int offset, Tape tape) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        long digits = digitsParsingResult.digits();
        currentIdx = digitsParsingResult.currentIdx();
        int digitCount = currentIdx - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        long exponent = 0L;
        boolean floatingPointNumber = false;
        if (46 == buffer[currentIdx]) {
            floatingPointNumber = true;
            int firstIdxAfterPeriod = ++currentIdx;
            digitsParsingResult = this.parseDigits(buffer, currentIdx, digits);
            digits = digitsParsingResult.digits();
            currentIdx = digitsParsingResult.currentIdx();
            exponent = firstIdxAfterPeriod - currentIdx;
            if (exponent == 0L) {
                throw new JsonParsingException("Invalid number. Decimal point has to be followed by a digit.");
            }
            digitCount = currentIdx - digitsStartIdx;
        }
        if (ExponentParser.isExponentIndicator(buffer[currentIdx])) {
            floatingPointNumber = true;
            ExponentParser.ExponentParsingResult exponentParsingResult = this.exponentParser.parse(buffer, ++currentIdx, exponent);
            exponent = exponentParsingResult.exponent();
            currentIdx = exponentParsingResult.currentIdx();
        }
        if (!CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        if (floatingPointNumber) {
            double value = this.doubleParser.parse(buffer, offset, negative, digitsStartIdx, digitCount, digits, exponent);
            tape.appendDouble(value);
        } else {
            if (NumberParser.isOutOfLongRange(negative, digits, digitCount)) {
                throw new JsonParsingException("Number value is out of long range ([-9223372036854775808, 9223372036854775807]).");
            }
            tape.appendInt64(negative ? (digits ^ 0xFFFFFFFFFFFFFFFFL) + 1L : digits);
        }
    }

    byte parseByte(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        long digits = digitsParsingResult.digits();
        currentIdx = digitsParsingResult.currentIdx();
        int digitCount = currentIdx - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        if (NumberParser.isOutOfByteRange(negative, digits, digitCount)) {
            throw new JsonParsingException("Number value is out of byte range ([-128, 127]).");
        }
        return (byte)(negative ? (digits ^ 0xFFFFFFFFFFFFFFFFL) + 1L : digits);
    }

    private static boolean isOutOfByteRange(boolean negative, long digits, int digitCount) {
        if (digitCount < 3) {
            return false;
        }
        if (digitCount > 3) {
            return true;
        }
        if (negative) {
            return digits > 128L;
        }
        return digits > 127L;
    }

    short parseShort(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        long digits = digitsParsingResult.digits();
        currentIdx = digitsParsingResult.currentIdx();
        int digitCount = currentIdx - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        if (NumberParser.isOutOfShortRange(negative, digits, digitCount)) {
            throw new JsonParsingException("Number value is out of short range ([-32768, 32767]).");
        }
        return (short)(negative ? (digits ^ 0xFFFFFFFFFFFFFFFFL) + 1L : digits);
    }

    private static boolean isOutOfShortRange(boolean negative, long digits, int digitCount) {
        if (digitCount < 5) {
            return false;
        }
        if (digitCount > 5) {
            return true;
        }
        if (negative) {
            return digits > 32768L;
        }
        return digits > 32767L;
    }

    int parseInt(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        long digits = digitsParsingResult.digits();
        currentIdx = digitsParsingResult.currentIdx();
        int digitCount = currentIdx - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        if (NumberParser.isOutOfIntRange(negative, digits, digitCount)) {
            throw new JsonParsingException("Number value is out of int range ([-2147483648, 2147483647]).");
        }
        return (int)(negative ? (digits ^ 0xFFFFFFFFFFFFFFFFL) + 1L : digits);
    }

    private static boolean isOutOfIntRange(boolean negative, long digits, int digitCount) {
        if (digitCount < 10) {
            return false;
        }
        if (digitCount > 10) {
            return true;
        }
        if (negative) {
            return digits > 0x80000000L;
        }
        return digits > Integer.MAX_VALUE;
    }

    long parseLong(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        long digits = digitsParsingResult.digits();
        currentIdx = digitsParsingResult.currentIdx();
        int digitCount = currentIdx - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        if (NumberParser.isOutOfLongRange(negative, digits, digitCount)) {
            throw new JsonParsingException("Number value is out of long range ([-9223372036854775808, 9223372036854775807]).");
        }
        return negative ? (digits ^ 0xFFFFFFFFFFFFFFFFL) + 1L : digits;
    }

    float parseFloat(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        int digitCount = (currentIdx = digitsParsingResult.currentIdx()) - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        long exponent = 0L;
        boolean floatingPointNumber = false;
        if (46 == buffer[currentIdx]) {
            floatingPointNumber = true;
            ++currentIdx;
            int firstIdxAfterPeriod = currentIdx;
            exponent = firstIdxAfterPeriod - (currentIdx = (digitsParsingResult = this.parseDigits(buffer, currentIdx, digitsParsingResult.digits())).currentIdx());
            if (exponent == 0L) {
                throw new JsonParsingException("Invalid number. Decimal point has to be followed by a digit.");
            }
            digitCount = currentIdx - digitsStartIdx;
        }
        if (ExponentParser.isExponentIndicator(buffer[currentIdx])) {
            floatingPointNumber = true;
            ExponentParser.ExponentParsingResult exponentParsingResult = this.exponentParser.parse(buffer, ++currentIdx, exponent);
            exponent = exponentParsingResult.exponent();
            currentIdx = exponentParsingResult.currentIdx();
        }
        if (!floatingPointNumber) {
            throw new JsonParsingException("Invalid floating-point number. Fraction or exponent part is missing.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        return this.floatParser.parse(buffer, offset, negative, digitsStartIdx, digitCount, digitsParsingResult.digits(), exponent);
    }

    double parseDouble(byte[] buffer, int len, int offset) {
        int currentIdx;
        boolean negative = buffer[offset] == 45;
        int digitsStartIdx = currentIdx = negative ? offset + 1 : offset;
        DigitsParsingResult digitsParsingResult = this.parseDigits(buffer, currentIdx, 0L);
        int digitCount = (currentIdx = digitsParsingResult.currentIdx()) - digitsStartIdx;
        if (digitCount == 0) {
            throw new JsonParsingException("Invalid number. Minus has to be followed by a digit.");
        }
        if (48 == buffer[digitsStartIdx] && digitCount > 1) {
            throw new JsonParsingException("Invalid number. Leading zeroes are not allowed.");
        }
        long exponent = 0L;
        boolean floatingPointNumber = false;
        if (46 == buffer[currentIdx]) {
            floatingPointNumber = true;
            ++currentIdx;
            int firstIdxAfterPeriod = currentIdx;
            exponent = firstIdxAfterPeriod - (currentIdx = (digitsParsingResult = this.parseDigits(buffer, currentIdx, digitsParsingResult.digits())).currentIdx());
            if (exponent == 0L) {
                throw new JsonParsingException("Invalid number. Decimal point has to be followed by a digit.");
            }
            digitCount = currentIdx - digitsStartIdx;
        }
        if (ExponentParser.isExponentIndicator(buffer[currentIdx])) {
            floatingPointNumber = true;
            ExponentParser.ExponentParsingResult exponentParsingResult = this.exponentParser.parse(buffer, ++currentIdx, exponent);
            exponent = exponentParsingResult.exponent();
            currentIdx = exponentParsingResult.currentIdx();
        }
        if (!floatingPointNumber) {
            throw new JsonParsingException("Invalid floating-point number. Fraction or exponent part is missing.");
        }
        if (currentIdx < len && !CharacterUtils.isStructuralOrWhitespace(buffer[currentIdx])) {
            throw new JsonParsingException("Number has to be followed by a structural character or whitespace.");
        }
        return this.doubleParser.parse(buffer, offset, negative, digitsStartIdx, digitCount, digitsParsingResult.digits(), exponent);
    }

    private static boolean isOutOfLongRange(boolean negative, long digits, int digitCount) {
        if (digitCount < 19) {
            return false;
        }
        if (digitCount > 19) {
            return true;
        }
        if (negative && digits == Long.MIN_VALUE) {
            return false;
        }
        return digits < 0L;
    }

    private DigitsParsingResult parseDigits(byte[] buffer, int currentIdx, long digits) {
        byte digit = NumberParser.convertCharacterToDigit(buffer[currentIdx]);
        while (digit >= 0 && digit <= 9) {
            digits = 10L * digits + (long)digit;
            digit = NumberParser.convertCharacterToDigit(buffer[++currentIdx]);
        }
        return this.digitsParsingResult.of(digits, currentIdx);
    }

    private static byte convertCharacterToDigit(byte b) {
        return (byte)(b - 48);
    }

    private static class DigitsParsingResult {
        private long digits;
        private int currentIdx;

        private DigitsParsingResult() {
        }

        DigitsParsingResult of(long digits, int currentIdx) {
            this.digits = digits;
            this.currentIdx = currentIdx;
            return this;
        }

        long digits() {
            return this.digits;
        }

        int currentIdx() {
            return this.currentIdx;
        }
    }
}

