/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.simdjson.ConstructorArgument;

class ConstructorArgumentsMap {
    private static final VarHandle VAR_HANDLE_LONG = MethodHandles.byteArrayViewVarHandle(Long.TYPE.arrayType(), ByteOrder.nativeOrder());
    private static final VarHandle VAR_HANDLE_INT = MethodHandles.byteArrayViewVarHandle(Integer.TYPE.arrayType(), ByteOrder.nativeOrder());
    private static final long M2 = 2053402189L;
    private final int argumentCount;
    private final int capacity;
    private final int moduloMask;
    private final byte[][] keys;
    private final ConstructorArgument[] arguments;

    ConstructorArgumentsMap(int argumentCount) {
        this.argumentCount = argumentCount;
        this.capacity = ConstructorArgumentsMap.ceilingPowerOfTwo(argumentCount);
        this.moduloMask = this.capacity - 1;
        this.arguments = new ConstructorArgument[this.capacity];
        this.keys = new byte[this.capacity][];
    }

    private static int ceilingPowerOfTwo(int argumentCount) {
        return 1 << -Integer.numberOfLeadingZeros(argumentCount - 1);
    }

    int getArgumentCount() {
        return this.argumentCount;
    }

    void put(byte[] fieldName, ConstructorArgument argument) {
        int place = this.findPlace(fieldName, fieldName.length);
        while (this.keys[place] != null) {
            place = place + 1 & this.moduloMask;
        }
        this.arguments[place] = argument;
        this.keys[place] = fieldName;
    }

    ConstructorArgument get(byte[] buffer, int len) {
        int place = this.findPlace(buffer, len);
        for (int i = 0; i < this.capacity; ++i) {
            byte[] key = this.keys[place];
            if (Arrays.equals(key, 0, key.length, buffer, 0, len)) {
                return this.arguments[place];
            }
            place = place + 1 & this.moduloMask;
        }
        return null;
    }

    private int findPlace(byte[] buffer, int len) {
        int hash = ConstructorArgumentsMap.hash(buffer, len);
        return hash & this.moduloMask;
    }

    private static int hash(byte[] data, int len) {
        long h = 0L;
        int i = 0;
        while (i + 7 < len) {
            h = h * 2053402189L + ConstructorArgumentsMap.getLongFromArray(data, i);
            i += 8;
        }
        if (i + 3 < len) {
            h = h * 2053402189L + (long)ConstructorArgumentsMap.getIntFromArray(data, i);
            i += 4;
        }
        while (i < len) {
            h = h * 2053402189L + (long)data[i];
            ++i;
        }
        return (int)((h *= 2053402189L) ^ h >>> 32);
    }

    private static int getIntFromArray(byte[] value, int i) {
        return VAR_HANDLE_INT.get(value, i);
    }

    private static long getLongFromArray(byte[] value, int i) {
        return VAR_HANDLE_LONG.get(value, i);
    }
}

